/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi.interceptors;

import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.util.Set;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.Counted;

@Counted
@Interceptor
@Priority(value=1010)
public class CountedInterceptor {
    private MetricRegistry registry;

    @AroundConstruct
    Object countedConstructor(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getConstructor());
    }

    @AroundInvoke
    Object countedMethod(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getMethod());
    }

    @AroundTimeout
    Object countedTimeout(InvocationContext context) throws Exception {
        return this.countedCallable(context, context.getMethod());
    }

    private <E extends Member & AnnotatedElement> Object countedCallable(InvocationContext context, E element) throws Exception {
        Counted countedAnno = ((AnnotatedElement)element).getAnnotation(Counted.class);
        this.registry = countedAnno != null ? SharedMetricRegistries.getOrCreate(countedAnno.scope()) : SharedMetricRegistries.getOrCreate("application");
        Set<MetricID> ids = ((LegacyMetricRegistryAdapter)this.registry).getMemberToMetricMappings().getCounters(new CDIMemberInfoAdapter<AnnotatedElement>().convert(element));
        if (ids == null || ids.isEmpty()) {
            throw SmallRyeMetricsMessages.msg.noMetricMappedForMember(element);
        }
        ids.stream().map(metricID -> {
            Counter metric = (Counter)this.registry.getCounters().get(metricID);
            if (metric == null) {
                throw new IllegalStateException("No metric with ID " + metricID + " found in registry");
            }
            return metric;
        }).forEach(Counter::inc);
        return context.proceed();
    }
}

