/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.legacyapi.MeterHolder;
import io.smallrye.metrics.legacyapi.MetricDescriptor;
import io.smallrye.metrics.legacyapi.MpMetadata;
import java.util.HashSet;

class CounterAdapter
implements org.eclipse.microprofile.metrics.Counter,
MeterHolder {
    Counter globalCompositeCounter;
    Counter promCounter;

    CounterAdapter() {
    }

    public CounterAdapter register(MpMetadata metadata, MetricDescriptor descriptor, MeterRegistry registry, String scope) {
        ThreadLocal<Boolean> threadLocal = SharedMetricRegistries.getThreadLocal(scope);
        threadLocal.set(true);
        if (this.globalCompositeCounter == null || metadata.cleanDirtyMetadata()) {
            HashSet<Tag> tagsSet = new HashSet<Tag>();
            for (Tag t : descriptor.tags()) {
                tagsSet.add(t);
            }
            tagsSet.add(Tag.of((String)"mp_scope", (String)scope));
            this.globalCompositeCounter = Counter.builder((String)descriptor.name()).description(metadata.getDescription()).baseUnit(metadata.getUnit()).tags(tagsSet).register((MeterRegistry)Metrics.globalRegistry);
            this.promCounter = registry.find(descriptor.name()).tags(tagsSet).counter();
            if (this.promCounter == null) {
                this.promCounter = this.globalCompositeCounter;
            }
        }
        threadLocal.set(false);
        return this;
    }

    public void inc() {
        this.globalCompositeCounter.increment();
    }

    public void inc(long l) {
        this.globalCompositeCounter.increment((double)l);
    }

    public long getCount() {
        return (long)this.promCounter.count();
    }

    @Override
    public Meter getMeter() {
        return this.globalCompositeCounter;
    }
}

