/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.legacyapi.MeterHolder;
import io.smallrye.metrics.legacyapi.MetricDescriptor;
import io.smallrye.metrics.legacyapi.MpMetadata;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import org.eclipse.microprofile.metrics.Gauge;

interface GaugeAdapter<T extends Number>
extends Gauge<T>,
MeterHolder {
    public GaugeAdapter<T> register(MpMetadata var1, MetricDescriptor var2, MeterRegistry var3, String var4);

    public static class NumberSupplierGauge<T extends Number>
    implements GaugeAdapter<T> {
        io.micrometer.core.instrument.Gauge gauge;
        final Supplier<T> supplier;

        NumberSupplierGauge(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        public GaugeAdapter<T> register(MpMetadata metadata, MetricDescriptor metricInfo, MeterRegistry registry, String scope) {
            if (this.gauge == null || metadata.cleanDirtyMetadata()) {
                ThreadLocal<Boolean> threadLocal = SharedMetricRegistries.getThreadLocal(scope);
                threadLocal.set(true);
                this.gauge = io.micrometer.core.instrument.Gauge.builder((String)metricInfo.name(), this.supplier).description(metadata.getDescription()).tags((Iterable)metricInfo.tags()).tags(new String[]{"mp_scope", scope}).baseUnit(metadata.getUnit()).strongReference(true).register((MeterRegistry)Metrics.globalRegistry);
                threadLocal.set(false);
            }
            return this;
        }

        @Override
        public Meter getMeter() {
            return this.gauge;
        }

        public T getValue() {
            return (T)((Number)this.supplier.get());
        }
    }

    public static class FunctionGauge<S, R extends Number>
    implements GaugeAdapter<R> {
        io.micrometer.core.instrument.Gauge gauge;
        final S obj;
        final Function<S, R> f;

        FunctionGauge(S obj, Function<S, R> f) {
            this.obj = obj;
            this.f = f;
        }

        @Override
        public GaugeAdapter<R> register(MpMetadata metadata, MetricDescriptor metricInfo, MeterRegistry registry, String scope) {
            ThreadLocal<Boolean> threadLocal = SharedMetricRegistries.getThreadLocal(scope);
            threadLocal.set(true);
            HashSet<Tag> tagsSet = new HashSet<Tag>();
            for (Tag t : metricInfo.tags()) {
                tagsSet.add(t);
            }
            tagsSet.add(Tag.of((String)"mp_scope", (String)scope));
            this.gauge = io.micrometer.core.instrument.Gauge.builder((String)metricInfo.name(), this.obj, obj -> ((Number)this.f.apply(obj)).doubleValue()).description(metadata.getDescription()).tags(tagsSet).baseUnit(metadata.getUnit()).strongReference(true).register((MeterRegistry)Metrics.globalRegistry);
            threadLocal.set(false);
            return this;
        }

        @Override
        public Meter getMeter() {
            return this.gauge;
        }

        public R getValue() {
            return (R)((Number)this.f.apply(this.obj));
        }
    }

    public static class DoubleFunctionGauge<S>
    implements GaugeAdapter<Double> {
        io.micrometer.core.instrument.Gauge gauge;
        final S obj;
        final ToDoubleFunction<S> f;

        DoubleFunctionGauge(S obj, ToDoubleFunction<S> f) {
            this.obj = obj;
            this.f = f;
        }

        @Override
        public GaugeAdapter<Double> register(MpMetadata metadata, MetricDescriptor metricInfo, MeterRegistry registry, String scope) {
            ThreadLocal<Boolean> threadLocal = SharedMetricRegistries.getThreadLocal(scope);
            threadLocal.set(true);
            HashSet<Tag> tagsSet = new HashSet<Tag>();
            for (Tag t : metricInfo.tags()) {
                tagsSet.add(t);
            }
            tagsSet.add(Tag.of((String)"mp_scope", (String)scope));
            this.gauge = io.micrometer.core.instrument.Gauge.builder((String)metricInfo.name(), this.obj, this.f).description(metadata.getDescription()).tags(tagsSet).baseUnit(metadata.getUnit()).strongReference(true).register((MeterRegistry)Metrics.globalRegistry);
            threadLocal.set(false);
            return this;
        }

        @Override
        public Meter getMeter() {
            return this.gauge;
        }

        public Double getValue() {
            return this.f.applyAsDouble(this.obj);
        }
    }
}

