/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.prometheus.PrometheusConfig;
import io.smallrye.metrics.base.LegacyBaseMetrics;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import io.smallrye.metrics.setup.ApplicationNameResolver;
import io.smallrye.metrics.setup.MPPrometheusMeterRegistry;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class SharedMetricRegistries {
    protected static final String GLOBAL_TAG_MALFORMED_EXCEPTION = "Malformed list of Global Tags. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*. Global Tag values must not be empty. Global Tag values MUST escape equal signs `=` and commas `,` with a backslash `\\` ";
    protected static final String GLOBAL_TAGS_VARIABLE = "mp.metrics.tags";
    protected static Tag[] SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS = null;
    private static final Map<String, MetricRegistry> registries = new ConcurrentHashMap<String, MetricRegistry>();
    private static final Map<String, ThreadLocal<Boolean>> threadLocalMap = new ConcurrentHashMap<String, ThreadLocal<Boolean>>();

    public static MetricRegistry getOrCreate(String scope) {
        return SharedMetricRegistries.getOrCreate(scope, null);
    }

    public static MetricRegistry getOrCreate(String scope, ApplicationNameResolver appNameResolver) {
        return registries.computeIfAbsent(scope, t -> new LegacyMetricRegistryAdapter(scope, SharedMetricRegistries.resolveMeterRegistry(scope), appNameResolver));
    }

    private static MeterRegistry resolveMeterRegistry(String scope) {
        MPPrometheusMeterRegistry meterRegistry = new MPPrometheusMeterRegistry(PrometheusConfig.DEFAULT, scope);
        Tag[] globalTags = SharedMetricRegistries.resolveMPConfigGlobalTagsByServer();
        if (globalTags.length != 0) {
            meterRegistry.config().commonTags(Arrays.asList(globalTags));
        }
        ThreadLocal<Boolean> threadLocal = ThreadLocal.withInitial(() -> false);
        threadLocalMap.put(scope, threadLocal);
        meterRegistry.config().meterFilter(MeterFilter.accept(id -> (Boolean)threadLocal.get() == true));
        meterRegistry.config().meterFilter(MeterFilter.deny());
        Metrics.addRegistry((MeterRegistry)meterRegistry);
        if (scope.equals("base")) {
            ThreadLocal<Boolean> base_Tl = SharedMetricRegistries.getThreadLocal("base");
            base_Tl.set(true);
            new LegacyBaseMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
            base_Tl.set(false);
        }
        return meterRegistry;
    }

    public static ThreadLocal<Boolean> getThreadLocal(String scope) {
        ThreadLocal<Boolean> tl = threadLocalMap.get(scope);
        if (tl == null) {
            throw new IllegalArgumentException("ThreadLocal for this registry does not exist");
        }
        return tl;
    }

    public static void drop(String scope) {
        registries.remove(scope);
    }

    public static void dropAll() {
        registries.clear();
    }

    private static synchronized Tag[] resolveMPConfigGlobalTagsByServer() {
        if (SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS == null) {
            Optional globalTags = ConfigProvider.getConfig().getOptionalValue(GLOBAL_TAGS_VARIABLE, String.class);
            SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS = globalTags.isPresent() ? SharedMetricRegistries.parseGlobalTags((String)globalTags.get()) : new Tag[]{};
        }
        return SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS == null ? null : SERVER_LEVEL_MPCONFIG_GLOBAL_TAGS;
    }

    public static boolean doesScopeExist(String scope) {
        return registries.containsKey(scope);
    }

    private static Tag[] parseGlobalTags(String globalTags) {
        if (globalTags == null || globalTags.length() == 0) {
            return null;
        }
        String[] kvPairs = globalTags.split("(?<!\\\\),");
        Tag[] arrayOfTags = new Tag[kvPairs.length];
        int count = 0;
        for (String kvString : kvPairs) {
            if (kvString.length() == 0) {
                throw new IllegalArgumentException(GLOBAL_TAG_MALFORMED_EXCEPTION);
            }
            String[] keyValueSplit = kvString.split("(?<!\\\\)=");
            if (keyValueSplit.length != 2 || keyValueSplit[0].length() == 0 || keyValueSplit[1].length() == 0) {
                throw new IllegalArgumentException(GLOBAL_TAG_MALFORMED_EXCEPTION);
            }
            String key = keyValueSplit[0];
            String value = keyValueSplit[1];
            if (!key.matches("[a-zA-Z_][a-zA-Z0-9_]*")) {
                throw new IllegalArgumentException("Invalid Tag name. Tag names must match the following regex [a-zA-Z_][a-zA-Z0-9_]*");
            }
            value = value.replace("\\,", ",");
            value = value.replace("\\=", "=");
            arrayOfTags[count] = Tag.of((String)key, (String)value);
            ++count;
        }
        return arrayOfTags;
    }
}

