package io.smallrye.metrics;

import java.util.Locale;
import java.io.Serializable;
import org.eclipse.microprofile.metrics.MetricID;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import io.smallrye.metrics.elementdesc.MemberInfo;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;
import jakarta.enterprise.inject.spi.AnnotatedField;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class SmallRyeMetricsLogging_$logger implements SmallRyeMetricsLogging, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SmallRyeMetricsLogging_$logger.class.getName();
    public SmallRyeMetricsLogging_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void unableToDetectVersion() {
        log.logf(FQCN, WARN, null, unableToDetectVersion$str());
    }
    protected String unableToDetectVersion$str() {
        return "SRMET01000: Unable to detect version of SmallRye Metrics";
    }
    @Override
    public final void logSmallRyeMetricsVersion(final String version) {
        log.logf(FQCN, INFO, null, logSmallRyeMetricsVersion$str(), version);
    }
    protected String logSmallRyeMetricsVersion$str() {
        return "SRMET01001: MicroProfile: Metrics activated (SmallRye Metrics version: %s)";
    }
    @Override
    public final void producerFieldDiscovered(final AnnotatedField<?> field) {
        log.logf(FQCN, DEBUG, null, producerFieldDiscovered$str(), field);
    }
    protected String producerFieldDiscovered$str() {
        return "SRMET01100: Metric producer field discovered: %s";
    }
    @Override
    public final void producerMethodDiscovered(final AnnotatedMethod<?> method) {
        log.logf(FQCN, DEBUG, null, producerMethodDiscovered$str(), method);
    }
    protected String producerMethodDiscovered$str() {
        return "SRMET01101: Metric producer method discovered: %s";
    }
    @Override
    public final void matchingMemberToMetric(final MemberInfo member, final MetricID metricID) {
        log.logf(FQCN, TRACE, null, matchingMemberToMetric$str(), member, metricID);
    }
    protected String matchingMemberToMetric$str() {
        return "SRMET01102: Matching member %s to metric ID=%s";
    }
    @Override
    public final void nameDoesNotContainPlaceHoldersOrTags(final String name) {
        log.logf(FQCN, WARN, null, nameDoesNotContainPlaceHoldersOrTags$str(), name);
    }
    protected String nameDoesNotContainPlaceHoldersOrTags$str() {
        return "SRMET01103: Name [%s] did not contain any placeholders or tags, no replacement will be done, check the configuration";
    }
    @Override
    public final void registerMetric(final MetricID metricID) {
        log.logf(FQCN, DEBUG, null, registerMetric1$str(), metricID);
    }
    protected String registerMetric1$str() {
        return "SRMET01200: Register metric [metricId: %s]";
    }
    @Override
    public final void registerMetric(final MetricID metricID, final Object origin) {
        log.logf(FQCN, DEBUG, null, registerMetric2$str(), metricID, origin);
    }
    protected String registerMetric2$str() {
        return "SRMET01201: Register metric [metricId: %s, origin: %s]";
    }
    @Override
    public final void removeMetricsByName(final String name) {
        log.logf(FQCN, DEBUG, null, removeMetricsByName$str(), name);
    }
    protected String removeMetricsByName$str() {
        return "SRMET01202: Removing metrics with [name: %s]";
    }
    @Override
    public final void removeMetricsById(final MetricID id) {
        log.logf(FQCN, DEBUG, null, removeMetricsById$str(), id);
    }
    protected String removeMetricsById$str() {
        return "SRMET01203: Removing metric with [id: %s]";
    }
    @Override
    public final void removeMetadata(final String name) {
        log.logf(FQCN, DEBUG, null, removeMetadata$str(), name);
    }
    protected String removeMetadata$str() {
        return "SRMET01204: Remove metadata for [name: %s]";
    }
    @Override
    public final void unableToExport(final String name, final Exception e) {
        log.logf(FQCN, DEBUG, e, unableToExport$str(), name);
    }
    protected String unableToExport$str() {
        return "SRMET01300: Unable to export metric %s";
    }
}
