/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.MemberToMetricMappings;
import io.smallrye.metrics.OriginAndMetadata;
import io.smallrye.metrics.SmallRyeMetricsLogging;
import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.UnspecifiedMetadata;
import io.smallrye.metrics.app.ConcurrentGaugeImpl;
import io.smallrye.metrics.app.CounterImpl;
import io.smallrye.metrics.app.ExponentiallyDecayingReservoir;
import io.smallrye.metrics.app.HistogramImpl;
import io.smallrye.metrics.app.MeterImpl;
import io.smallrye.metrics.app.SimpleTimerImpl;
import io.smallrye.metrics.app.TimerImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricFilter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

@Vetoed
public class MetricsRegistryImpl
implements MetricRegistry {
    private Map<String, Metadata> metadataMap = new ConcurrentHashMap<String, Metadata>();
    private Map<MetricID, Metric> metricMap = new ConcurrentHashMap<MetricID, Metric>();
    private Map<MetricID, Object> originMap = new HashMap<MetricID, Object>();
    private MetricRegistry.Type registryType;
    private MemberToMetricMappings memberToMetricMappings;

    public MetricsRegistryImpl() {
        this(null);
    }

    public MetricsRegistryImpl(MetricRegistry.Type registryType) {
        this.registryType = registryType;
        if (registryType == MetricRegistry.Type.APPLICATION) {
            this.memberToMetricMappings = new MemberToMetricMappings();
        }
    }

    public synchronized <T extends Metric> T register(String name, T metric) {
        MetricID metricID = new MetricID(name);
        if (this.metricMap.keySet().contains(metricID)) {
            throw SmallRyeMetricsMessages.msg.metricWithNameAlreadyExists(name);
        }
        MetricType type = this.inferMetricType(metric.getClass());
        if (type == null || type.equals((Object)MetricType.INVALID)) {
            throw SmallRyeMetricsMessages.msg.unableToInferMetricType();
        }
        Metadata m = Metadata.builder().withName(name).withType(type).build();
        this.metricMap.put(metricID, metric);
        this.metadataMap.put(name, m);
        return metric;
    }

    public <T extends Metric> T register(Metadata metadata, T metric) {
        return this.register(this.sanitizeMetadata(metadata, metric.getClass()), metric, null);
    }

    public synchronized <T extends Metric> T register(Metadata metadata, T metric, Tag ... tags) {
        String name = metadata.getName();
        if (name == null) {
            throw SmallRyeMetricsMessages.msg.metricNameMustNotBeNullOrEmpty();
        }
        MetricID metricID = new MetricID(name, tags);
        Metadata existingMetadata = this.metadataMap.get(name);
        if (this.metricMap.containsKey(metricID) && metadata.getTypeRaw().equals((Object)MetricType.GAUGE)) {
            throw SmallRyeMetricsMessages.msg.gaugeWithIdAlreadyExists(metricID);
        }
        if (existingMetadata != null) {
            if (metadata instanceof UnspecifiedMetadata) {
                if (!metadata.getType().equals(existingMetadata.getType())) {
                    throw SmallRyeMetricsMessages.msg.metricExistsUnderDifferentType(name, existingMetadata.getType());
                }
                this.metricMap.put(metricID, metric);
            } else {
                this.verifyMetadataEquality(metadata, existingMetadata);
                this.metricMap.put(metricID, metric);
                if (metadata instanceof OriginAndMetadata) {
                    this.originMap.put(metricID, ((OriginAndMetadata)metadata).getOrigin());
                }
            }
        } else if (metadata instanceof UnspecifiedMetadata) {
            Metadata realMetadata = ((UnspecifiedMetadata)metadata).convertToRealMetadata();
            this.metadataMap.put(name, realMetadata);
            this.metricMap.put(metricID, metric);
        } else {
            if (metadata instanceof OriginAndMetadata) {
                this.originMap.put(metricID, ((OriginAndMetadata)metadata).getOrigin());
                this.metadataMap.put(name, ((OriginAndMetadata)metadata).getMetadata());
            } else {
                this.metadataMap.put(name, this.sanitizeMetadata(metadata, metric.getClass()));
            }
            this.metricMap.put(metricID, metric);
        }
        return metric;
    }

    private void verifyMetadataEquality(Metadata newMetadata, Metadata existingMetadata) {
        if (!existingMetadata.getTypeRaw().equals((Object)newMetadata.getTypeRaw())) {
            throw SmallRyeMetricsMessages.msg.metricExistsUnderDifferentType(newMetadata.getName(), existingMetadata.getType());
        }
        if (!(newMetadata instanceof UnspecifiedMetadata)) {
            String newDescription;
            String newUnit;
            String existingUnit = existingMetadata.getUnit();
            if (!existingUnit.equals(newUnit = newMetadata.getUnit())) {
                throw SmallRyeMetricsMessages.msg.unitDiffersFromPreviousUsage(existingUnit);
            }
            String existingDescription = existingMetadata.getDescription();
            if (!existingDescription.equals(newDescription = newMetadata.getDescription())) {
                throw SmallRyeMetricsMessages.msg.descriptionDiffersFromPreviousUsage();
            }
            if (!existingMetadata.getDisplayName().equals(newMetadata.getDisplayName())) {
                throw SmallRyeMetricsMessages.msg.displayNameDiffersFromPreviousUsage();
            }
        }
    }

    public Counter counter(String name) {
        return (Counter)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.COUNTER));
    }

    public Counter counter(String name, Tag ... tags) {
        return (Counter)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.COUNTER));
    }

    public Counter counter(Metadata metadata, Tag ... tags) {
        return (Counter)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.COUNTER));
    }

    public Counter counter(Metadata metadata) {
        return (Counter)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.COUNTER));
    }

    public Counter counter(MetricID metricID) {
        return (Counter)this.get(metricID, new UnspecifiedMetadata(metricID.getName(), MetricType.COUNTER));
    }

    public ConcurrentGauge concurrentGauge(String name) {
        return (ConcurrentGauge)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.CONCURRENT_GAUGE));
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata) {
        return (ConcurrentGauge)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.CONCURRENT_GAUGE));
    }

    public ConcurrentGauge concurrentGauge(MetricID metricID) {
        return (ConcurrentGauge)this.get(metricID, new UnspecifiedMetadata(metricID.getName(), MetricType.CONCURRENT_GAUGE));
    }

    public ConcurrentGauge concurrentGauge(String name, Tag ... tags) {
        return (ConcurrentGauge)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.CONCURRENT_GAUGE));
    }

    public ConcurrentGauge concurrentGauge(Metadata metadata, Tag ... tags) {
        return (ConcurrentGauge)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.CONCURRENT_GAUGE));
    }

    public <T, R extends Number> Gauge<R> gauge(String name, T stateObject, Function<T, R> function, Tag ... tags) {
        Objects.requireNonNull(stateObject);
        Gauge gauge = () -> (Number)function.apply(stateObject);
        return this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.GAUGE), gauge);
    }

    public <T, R extends Number> Gauge<R> gauge(MetricID metricID, T stateObject, Function<T, R> function) {
        Objects.requireNonNull(stateObject);
        Gauge gauge = () -> (Number)function.apply(stateObject);
        return this.get(metricID, new UnspecifiedMetadata(metricID.getName(), MetricType.GAUGE), gauge);
    }

    public <T, R extends Number> Gauge<R> gauge(Metadata metadata, T stateObject, Function<T, R> function, Tag ... tags) {
        Objects.requireNonNull(stateObject);
        Gauge gauge = () -> (Number)function.apply(stateObject);
        return this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.GAUGE), gauge);
    }

    public <T extends Number> Gauge<T> gauge(String name, Supplier<T> supplier, Tag ... tags) {
        Objects.requireNonNull(supplier);
        Gauge gauge = supplier::get;
        return this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.GAUGE), gauge);
    }

    public <T extends Number> Gauge<T> gauge(MetricID metricID, Supplier<T> supplier) {
        Objects.requireNonNull(supplier);
        Gauge gauge = supplier::get;
        return this.get(metricID, new UnspecifiedMetadata(metricID.getName(), MetricType.GAUGE), gauge);
    }

    public <T extends Number> Gauge<T> gauge(Metadata metadata, Supplier<T> supplier, Tag ... tags) {
        Objects.requireNonNull(supplier);
        Gauge gauge = supplier::get;
        return this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.GAUGE), gauge);
    }

    public Histogram histogram(String name) {
        return (Histogram)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.HISTOGRAM));
    }

    public Histogram histogram(Metadata metadata) {
        return (Histogram)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.HISTOGRAM));
    }

    public Histogram histogram(MetricID metricID) {
        return (Histogram)this.get(metricID, new UnspecifiedMetadata(metricID.getName(), MetricType.HISTOGRAM));
    }

    public Histogram histogram(String name, Tag ... tags) {
        return (Histogram)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.HISTOGRAM));
    }

    public Histogram histogram(Metadata metadata, Tag ... tags) {
        return (Histogram)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.HISTOGRAM));
    }

    public Meter meter(String name) {
        return (Meter)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.METERED));
    }

    public Meter meter(Metadata metadata) {
        return (Meter)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.METERED));
    }

    public Meter meter(MetricID metricID) {
        return (Meter)this.get(metricID, new UnspecifiedMetadata(metricID.getName(), MetricType.METERED));
    }

    public Meter meter(String name, Tag ... tags) {
        return (Meter)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.METERED));
    }

    public Meter meter(Metadata metadata, Tag ... tags) {
        return (Meter)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.METERED));
    }

    public Timer timer(String name) {
        return (Timer)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.TIMER));
    }

    public Timer timer(Metadata metadata) {
        return (Timer)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.TIMER));
    }

    public Timer timer(MetricID metricID) {
        return (Timer)this.get(metricID, new UnspecifiedMetadata(metricID.getName(), MetricType.TIMER));
    }

    public Timer timer(String name, Tag ... tags) {
        return (Timer)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.TIMER));
    }

    public Timer timer(Metadata metadata, Tag ... tags) {
        return (Timer)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.TIMER));
    }

    public SimpleTimer simpleTimer(String name) {
        return (SimpleTimer)this.get(new MetricID(name), new UnspecifiedMetadata(name, MetricType.SIMPLE_TIMER));
    }

    public SimpleTimer simpleTimer(String name, Tag ... tags) {
        return (SimpleTimer)this.get(new MetricID(name, tags), new UnspecifiedMetadata(name, MetricType.SIMPLE_TIMER));
    }

    public SimpleTimer simpleTimer(Metadata metadata) {
        return (SimpleTimer)this.get(new MetricID(metadata.getName()), this.sanitizeMetadata(metadata, MetricType.SIMPLE_TIMER));
    }

    public SimpleTimer simpleTimer(Metadata metadata, Tag ... tags) {
        return (SimpleTimer)this.get(new MetricID(metadata.getName(), tags), this.sanitizeMetadata(metadata, MetricType.SIMPLE_TIMER));
    }

    public SimpleTimer simpleTimer(MetricID metricID) {
        return (SimpleTimer)this.get(metricID, new UnspecifiedMetadata(metricID.getName(), MetricType.SIMPLE_TIMER));
    }

    private <T extends Metric> T get(MetricID metricID, Metadata metadata) {
        return this.get(metricID, metadata, null);
    }

    private synchronized <T extends Metric> T get(MetricID metricID, Metadata metadata, T implementor) {
        String name = metadata.getName();
        MetricType type = metadata.getTypeRaw();
        if (name == null || name.isEmpty()) {
            throw SmallRyeMetricsMessages.msg.metricNameMustNotBeNullOrEmpty();
        }
        Metadata previousMetadata = this.metadataMap.get(name);
        Metric previousMetric = this.metricMap.get(metricID);
        if (previousMetric == null) {
            Object m;
            switch (type) {
                case COUNTER: {
                    m = new CounterImpl();
                    break;
                }
                case GAUGE: {
                    m = implementor;
                    break;
                }
                case METERED: {
                    m = new MeterImpl();
                    break;
                }
                case HISTOGRAM: {
                    m = new HistogramImpl(new ExponentiallyDecayingReservoir());
                    break;
                }
                case TIMER: {
                    m = new TimerImpl(new ExponentiallyDecayingReservoir());
                    break;
                }
                case CONCURRENT_GAUGE: {
                    m = new ConcurrentGaugeImpl();
                    break;
                }
                case SIMPLE_TIMER: {
                    m = new SimpleTimerImpl();
                    break;
                }
                default: {
                    throw new IllegalStateException("Must not happen");
                }
            }
            if (metadata instanceof OriginAndMetadata) {
                SmallRyeMetricsLogging.log.registerMetric(metricID, type, ((OriginAndMetadata)metadata).getOrigin());
            } else {
                SmallRyeMetricsLogging.log.registerMetric(metricID, type);
            }
            this.register(metadata, m, metricID.getTagsAsList().toArray(new Tag[0]));
        } else {
            if (!previousMetadata.getTypeRaw().equals((Object)metadata.getTypeRaw())) {
                throw SmallRyeMetricsMessages.msg.metricExistsUnderDifferentType(name, previousMetadata.getType());
            }
            if (!(metadata instanceof OriginAndMetadata) || this.originMap.get(metricID) == null || !this.areCompatibleOrigins(this.originMap.get(metricID), ((OriginAndMetadata)metadata).getOrigin())) {
                this.verifyMetadataEquality(metadata, previousMetadata);
            }
        }
        return (T)this.metricMap.get(metricID);
    }

    private boolean areCompatibleOrigins(Object left, Object right) {
        if (left.equals(right)) {
            return true;
        }
        return left instanceof InjectionPoint || right instanceof InjectionPoint;
    }

    public boolean remove(String metricName) {
        SmallRyeMetricsLogging.log.removeMetricsByName(metricName);
        for (MetricID metricID : this.metricMap.keySet()) {
            if (!metricID.getName().equals(metricName)) continue;
            this.metricMap.remove(metricID);
        }
        return this.metadataMap.remove(metricName) != null;
    }

    public synchronized boolean remove(MetricID metricID) {
        if (this.metricMap.containsKey(metricID)) {
            SmallRyeMetricsLogging.log.removeMetricsById(metricID);
            this.metricMap.remove(metricID);
            String name = metricID.getName();
            if (this.metricMap.keySet().stream().noneMatch(id -> id.getName().equals(name))) {
                SmallRyeMetricsLogging.log.removeMetadata(name);
                this.metadataMap.remove(name);
            }
            return true;
        }
        return false;
    }

    public void removeMatching(MetricFilter metricFilter) {
        for (Map.Entry<MetricID, Metric> entry : this.metricMap.entrySet()) {
            if (!metricFilter.matches(entry.getKey(), entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public SortedSet<String> getNames() {
        TreeSet<String> out = new TreeSet<String>();
        for (MetricID id : this.metricMap.keySet()) {
            out.add(id.getName());
        }
        return out;
    }

    public SortedSet<MetricID> getMetricIDs() {
        return new TreeSet<MetricID>(this.metricMap.keySet());
    }

    public SortedMap<MetricID, Gauge> getGauges() {
        return this.getGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Gauge> getGauges(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.GAUGE, metricFilter);
    }

    public SortedMap<MetricID, Counter> getCounters() {
        return this.getCounters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Counter> getCounters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.COUNTER, metricFilter);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges() {
        return this.getConcurrentGauges(MetricFilter.ALL);
    }

    public SortedMap<MetricID, ConcurrentGauge> getConcurrentGauges(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.CONCURRENT_GAUGE, metricFilter);
    }

    public SortedMap<MetricID, Histogram> getHistograms() {
        return this.getHistograms(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Histogram> getHistograms(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.HISTOGRAM, metricFilter);
    }

    public SortedMap<MetricID, Meter> getMeters() {
        return this.getMeters(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Meter> getMeters(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.METERED, metricFilter);
    }

    public SortedMap<MetricID, Timer> getTimers() {
        return this.getTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, Timer> getTimers(MetricFilter metricFilter) {
        return this.getMetrics(MetricType.TIMER, metricFilter);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers() {
        return this.getSimpleTimers(MetricFilter.ALL);
    }

    public SortedMap<MetricID, SimpleTimer> getSimpleTimers(MetricFilter filter) {
        return this.getMetrics(MetricType.SIMPLE_TIMER, filter);
    }

    public Map<MetricID, Metric> getMetrics() {
        return new HashMap<MetricID, Metric>(this.metricMap);
    }

    public Metric getMetric(MetricID metricID) {
        return this.metricMap.get(metricID);
    }

    public <T extends Metric> T getMetric(MetricID metricID, Class<T> asType) {
        try {
            return (T)((Metric)asType.cast(this.getMetric(metricID)));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(metricID + " was not of expected type " + asType, e);
        }
    }

    public Counter getCounter(MetricID metricID) {
        return this.getMetric(metricID, Counter.class);
    }

    public ConcurrentGauge getConcurrentGauge(MetricID metricID) {
        return this.getMetric(metricID, ConcurrentGauge.class);
    }

    public Gauge<?> getGauge(MetricID metricID) {
        return this.getMetric(metricID, Gauge.class);
    }

    public Histogram getHistogram(MetricID metricID) {
        return this.getMetric(metricID, Histogram.class);
    }

    public Meter getMeter(MetricID metricID) {
        return this.getMetric(metricID, Meter.class);
    }

    public Timer getTimer(MetricID metricID) {
        return this.getMetric(metricID, Timer.class);
    }

    public SimpleTimer getSimpleTimer(MetricID metricID) {
        return this.getMetric(metricID, SimpleTimer.class);
    }

    public SortedMap<MetricID, Metric> getMetrics(MetricFilter filter) {
        TreeMap<MetricID, Metric> out = new TreeMap<MetricID, Metric>();
        for (Map.Entry<MetricID, Metric> entry : this.metricMap.entrySet()) {
            if (!filter.matches(entry.getKey(), entry.getValue())) continue;
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    public <T extends Metric> SortedMap<MetricID, T> getMetrics(Class<T> ofType, MetricFilter filter) {
        return this.getMetrics((metricID, metric) -> filter.matches(metricID, metric) && ofType.isAssignableFrom(metric.getClass()));
    }

    private Metadata sanitizeMetadata(Metadata metadata, Class<?> metricClass) {
        if (metadata.getTypeRaw() == null || metadata.getTypeRaw() == MetricType.INVALID) {
            MetricType inferredMetricType = this.inferMetricType(metricClass);
            return Metadata.builder((Metadata)metadata).withType(inferredMetricType).build();
        }
        return metadata;
    }

    private Metadata sanitizeMetadata(Metadata metadata, MetricType metricType) {
        if (metadata.getTypeRaw() == null || metadata.getTypeRaw() == MetricType.INVALID) {
            return Metadata.builder((Metadata)metadata).withType(metricType).build();
        }
        if (metadata.getTypeRaw() != metricType) {
            throw SmallRyeMetricsMessages.msg.typeMismatch(metricType, metadata.getTypeRaw());
        }
        return metadata;
    }

    private <T extends Metric> SortedMap<MetricID, T> getMetrics(MetricType type, MetricFilter filter) {
        TreeMap<MetricID, Metric> out = new TreeMap<MetricID, Metric>();
        for (Map.Entry<MetricID, Metric> entry : this.metricMap.entrySet()) {
            if (!this.isSameType(entry.getValue(), type) || !filter.matches(entry.getKey(), entry.getValue())) continue;
            out.put(entry.getKey(), entry.getValue());
        }
        return out;
    }

    private boolean isSameType(Metric metricInstance, MetricType type) {
        switch (type) {
            case CONCURRENT_GAUGE: {
                return metricInstance instanceof ConcurrentGauge;
            }
            case GAUGE: {
                return metricInstance instanceof Gauge;
            }
            case HISTOGRAM: {
                return metricInstance instanceof Histogram;
            }
            case TIMER: {
                return metricInstance instanceof Timer;
            }
            case METERED: {
                return metricInstance instanceof Meter;
            }
            case COUNTER: {
                return metricInstance instanceof Counter;
            }
            case SIMPLE_TIMER: {
                return metricInstance instanceof SimpleTimer;
            }
        }
        throw new IllegalArgumentException();
    }

    public synchronized Map<String, Metadata> getMetadata() {
        return new HashMap<String, Metadata>(this.metadataMap);
    }

    public Metadata getMetadata(String name) {
        return this.metadataMap.get(name);
    }

    public MetricRegistry.Type getType() {
        return this.registryType;
    }

    public MemberToMetricMappings getMemberToMetricMappings() {
        return this.memberToMetricMappings;
    }

    private MetricType inferMetricType(Class<?> clazz) {
        MetricType direct = this.metricTypeFromClass(clazz);
        if (direct != null) {
            return direct;
        }
        MetricType candidateType = null;
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            candidateType = this.inferMetricType(superClass);
        }
        for (Class<?> implementedInterface : clazz.getInterfaces()) {
            MetricType newCandidateType = this.inferMetricType(implementedInterface);
            if (candidateType == null) {
                candidateType = newCandidateType;
                continue;
            }
            if (newCandidateType == null || candidateType.equals((Object)newCandidateType)) continue;
            throw SmallRyeMetricsMessages.msg.ambiguousMetricType(newCandidateType, candidateType);
        }
        return candidateType;
    }

    private MetricType metricTypeFromClass(Class<?> in) {
        if (in.equals(Counter.class)) {
            return MetricType.COUNTER;
        }
        if (in.equals(Gauge.class)) {
            return MetricType.GAUGE;
        }
        if (in.equals(ConcurrentGauge.class)) {
            return MetricType.CONCURRENT_GAUGE;
        }
        if (in.equals(Meter.class)) {
            return MetricType.METERED;
        }
        if (in.equals(Timer.class)) {
            return MetricType.TIMER;
        }
        if (in.equals(SimpleTimer.class)) {
            return MetricType.SIMPLE_TIMER;
        }
        if (in.equals(Histogram.class)) {
            return MetricType.HISTOGRAM;
        }
        return null;
    }
}

