/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup;

import io.smallrye.metrics.OriginAndMetadata;
import io.smallrye.metrics.TagsUtils;
import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.elementdesc.MemberInfo;
import io.smallrye.metrics.interceptors.MetricResolver;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.SimplyTimed;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class MetricsMetadata {
    private MetricsMetadata() {
    }

    public static void registerMetrics(MetricRegistry registry, MetricResolver resolver, BeanInfo bean, MemberInfo element) {
        MetricResolver.Of<Timed> timed;
        MetricResolver.Of<SimplyTimed> simplyTimed;
        MetricResolver.Of<Metered> metered;
        MetricResolver.Of<ConcurrentGauge> concurrentGauge;
        MetricResolver.Of<Counted> counted = resolver.counted(bean, element);
        if (counted.isPresent()) {
            AnnotationInfo t = counted.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, counted.metricName(), t.unit(), t.description(), t.displayName(), MetricType.COUNTER, t.reusable());
            registry.counter(metadata, TagsUtils.parseTagsAsArray(t.tags()));
        }
        if ((concurrentGauge = resolver.concurrentGauge(bean, element)).isPresent()) {
            AnnotationInfo t = concurrentGauge.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, concurrentGauge.metricName(), t.unit(), t.description(), t.displayName(), MetricType.CONCURRENT_GAUGE, t.reusable());
            registry.concurrentGauge(metadata, TagsUtils.parseTagsAsArray(t.tags()));
        }
        if ((metered = resolver.metered(bean, element)).isPresent()) {
            AnnotationInfo t = metered.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, metered.metricName(), t.unit(), t.description(), t.displayName(), MetricType.METERED, t.reusable());
            registry.meter(metadata, TagsUtils.parseTagsAsArray(t.tags()));
        }
        if ((simplyTimed = resolver.simplyTimed(bean, element)).isPresent()) {
            AnnotationInfo t = simplyTimed.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, simplyTimed.metricName(), t.unit(), t.description(), t.displayName(), MetricType.SIMPLE_TIMER, t.reusable());
            registry.simpleTimer(metadata, TagsUtils.parseTagsAsArray(t.tags()));
        }
        if ((timed = resolver.timed(bean, element)).isPresent()) {
            AnnotationInfo t = timed.metricAnnotation();
            Metadata metadata = MetricsMetadata.getMetadata(element, timed.metricName(), t.unit(), t.description(), t.displayName(), MetricType.TIMER, t.reusable());
            registry.timer(metadata, TagsUtils.parseTagsAsArray(t.tags()));
        }
    }

    public static Metadata getMetadata(Object origin, String name, String unit, String description, String displayName, MetricType type, boolean reusable) {
        Metadata metadata = Metadata.builder().withName(name).withType(type).withUnit(unit).withDescription(description).withDisplayName(displayName).reusable(reusable).build();
        return new OriginAndMetadata(origin, metadata);
    }
}

