/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup;

import io.smallrye.metrics.MetricProducer;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.MetricsRequestHandler;
import io.smallrye.metrics.TagsUtils;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIBeanInfoAdapter;
import io.smallrye.metrics.elementdesc.adapter.cdi.CDIMemberInfoAdapter;
import io.smallrye.metrics.interceptors.ConcurrentGaugeInterceptor;
import io.smallrye.metrics.interceptors.CountedInterceptor;
import io.smallrye.metrics.interceptors.MeteredInterceptor;
import io.smallrye.metrics.interceptors.MetricName;
import io.smallrye.metrics.interceptors.MetricNameFactory;
import io.smallrye.metrics.interceptors.MetricResolver;
import io.smallrye.metrics.interceptors.MetricsBinding;
import io.smallrye.metrics.interceptors.MetricsInterceptor;
import io.smallrye.metrics.interceptors.TimedInterceptor;
import io.smallrye.metrics.setup.AnnotatedTypeDecorator;
import io.smallrye.metrics.setup.MetricsMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.Timed;
import org.jboss.logging.Logger;

public class MetricCdiInjectionExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"io.smallrye.metrics");
    private static final AnnotationLiteral<MetricsBinding> METRICS_BINDING = new AnnotationLiteral<MetricsBinding>(){};
    private static final AnnotationLiteral<Default> DEFAULT = new AnnotationLiteral<Default>(){};
    private final Map<Bean<?>, AnnotatedMember<?>> metricsFromProducers = new HashMap();
    private final Map<Bean<?>, List<AnnotatedMember<?>>> metricsFromAnnotatedMethods = new HashMap();
    private final List<Class<?>> metricsInterfaces;

    public MetricCdiInjectionExtension() {
        log.debug((Object)"MetricCdiInjectionExtension");
        this.metricsInterfaces = new ArrayList();
    }

    private void addInterceptorBindings(@Observes BeforeBeanDiscovery bbd, BeanManager manager) {
        log.info((Object)"MicroProfile: Metrics activated");
        String extensionName = MetricCdiInjectionExtension.class.getName();
        for (Class clazz : new Class[]{MetricProducer.class, MetricNameFactory.class, MetricsInterceptor.class, MetricRegistries.class, MeteredInterceptor.class, CountedInterceptor.class, ConcurrentGaugeInterceptor.class, TimedInterceptor.class, MetricsRequestHandler.class}) {
            bbd.addAnnotatedType(manager.createAnnotatedType(clazz), extensionName + "_" + clazz.getName());
        }
    }

    private <X> void findAnnotatedInterfaces(@Observes @WithAnnotations(value={Counted.class, Gauge.class, Metered.class, Timed.class, ConcurrentGauge.class}) ProcessAnnotatedType<X> pat) {
        Class clazz = pat.getAnnotatedType().getJavaClass();
        Package pack = clazz.getPackage();
        if (pack != null && pack.getName().equals(MetricsInterceptor.class.getPackage().getName())) {
            return;
        }
        if (clazz.isInterface()) {
            this.metricsInterfaces.add(clazz);
        }
    }

    private <X> void applyMetricsBinding(@Observes @WithAnnotations(value={Gauge.class}) ProcessAnnotatedType<X> pat) {
        Class clazz = pat.getAnnotatedType().getJavaClass();
        Package pack = clazz.getPackage();
        if (!(pack != null && pack.getName().equals(MetricsInterceptor.class.getPackage().getName()) || clazz.isInterface())) {
            AnnotatedTypeDecorator newPAT = new AnnotatedTypeDecorator(pat.getAnnotatedType(), (Annotation)METRICS_BINDING);
            log.debugf("annotations: %s", newPAT.getAnnotations());
            log.debugf("methods: %s", newPAT.getMethods());
            pat.setAnnotatedType(newPAT);
        }
    }

    private <X> void findAnnotatedMethods(@Observes ProcessManagedBean<X> bean) {
        if (bean.getBean().getBeanClass().getPackage().equals(MetricsInterceptor.class.getPackage())) {
            return;
        }
        ArrayList<AnnotatedMethod> list = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod aMethod : bean.getAnnotatedBeanClass().getMethods()) {
            Method method = aMethod.getJavaMember();
            if (method.isSynthetic() || Modifier.isPrivate(method.getModifiers())) continue;
            list.add(aMethod);
        }
        list.addAll(bean.getAnnotatedBeanClass().getConstructors());
        if (!list.isEmpty()) {
            this.metricsFromAnnotatedMethods.put(bean.getBean(), list);
        }
    }

    private void findMetricProducerFields(@Observes ProcessProducerField<? extends org.eclipse.microprofile.metrics.Metric, ?> ppf) {
        log.infof("Metrics producer field discovered: %s", (Object)ppf.getAnnotatedProducerField());
        this.metricsFromProducers.put((Bean<?>)ppf.getBean(), (AnnotatedMember<?>)ppf.getAnnotatedProducerField());
    }

    private void findMetricProducerMethods(@Observes ProcessProducerMethod<? extends org.eclipse.microprofile.metrics.Metric, ?> ppm) {
        if (!ppm.getBean().getBeanClass().equals(MetricProducer.class)) {
            log.infof("Metrics producer method discovered: %s", (Object)ppm.getAnnotatedProducerMethod());
            this.metricsFromProducers.put((Bean<?>)ppm.getBean(), (AnnotatedMember<?>)ppm.getAnnotatedProducerMethod());
        }
    }

    void registerMetrics(@Observes AfterDeploymentValidation adv, BeanManager manager) {
        MetricRegistry registry = MetricCdiInjectionExtension.getReference(manager, MetricRegistry.class);
        MetricName name = MetricCdiInjectionExtension.getReference(manager, MetricName.class);
        CDIBeanInfoAdapter beanInfoAdapter = new CDIBeanInfoAdapter();
        CDIMemberInfoAdapter<Member> memberInfoAdapter = new CDIMemberInfoAdapter<Member>();
        for (Map.Entry<Bean<?>, AnnotatedMember<?>> entry : this.metricsFromProducers.entrySet()) {
            if (!entry.getKey().getQualifiers().contains(DEFAULT) || MetricCdiInjectionExtension.hasInjectionPointMetadata(entry.getValue())) continue;
            String metricName = name.of(entry.getValue());
            Metric metricAnnotation = (Metric)entry.getValue().getAnnotation(Metric.class);
            if (metricAnnotation != null) {
                Object reference = MetricCdiInjectionExtension.getReference(manager, entry.getValue().getBaseType(), entry.getKey());
                if (reference == null) {
                    adv.addDeploymentProblem((Throwable)new IllegalStateException("null was returned from " + entry.getValue()));
                    return;
                }
                Class<?> clazz = reference.getClass();
                MetricType type = MetricType.from(clazz.getInterfaces().length == 0 ? clazz.getSuperclass().getInterfaces()[0] : clazz.getInterfaces()[0]);
                Metadata metadata = MetricsMetadata.getMetadata(metricAnnotation, metricName, metricAnnotation.unit(), metricAnnotation.description(), metricAnnotation.displayName(), type, false);
                Tag[] tags = TagsUtils.parseTagsAsArray(metricAnnotation.tags());
                registry.register(metadata, (org.eclipse.microprofile.metrics.Metric)MetricCdiInjectionExtension.getReference(manager, entry.getValue().getBaseType(), entry.getKey()), tags);
                continue;
            }
            registry.register(metricName, (org.eclipse.microprofile.metrics.Metric)MetricCdiInjectionExtension.getReference(manager, entry.getValue().getBaseType(), entry.getKey()));
        }
        for (Map.Entry<Bean<?>, Object> entry : this.metricsFromAnnotatedMethods.entrySet()) {
            Bean<?> bean = entry.getKey();
            for (AnnotatedMember method : (List)entry.getValue()) {
                MetricsMetadata.registerMetrics(registry, new MetricResolver(), beanInfoAdapter.convert(bean.getBeanClass()), memberInfoAdapter.convert(method.getJavaMember()));
            }
        }
        if (!this.metricsInterfaces.isEmpty()) {
            MetricResolver resolver = new MetricResolver();
            for (Class<?> metricsInterface : this.metricsInterfaces) {
                for (Method method : metricsInterface.getDeclaredMethods()) {
                    if (method.isDefault() || Modifier.isStatic(method.getModifiers())) continue;
                    MetricsMetadata.registerMetrics(registry, resolver, beanInfoAdapter.convert(metricsInterface), memberInfoAdapter.convert(method));
                }
            }
        }
        this.metricsInterfaces.clear();
        this.metricsFromProducers.clear();
        this.metricsFromAnnotatedMethods.clear();
    }

    private static boolean hasInjectionPointMetadata(AnnotatedMember<?> member) {
        if (!(member instanceof AnnotatedMethod)) {
            return false;
        }
        AnnotatedMethod method = (AnnotatedMethod)member;
        for (AnnotatedParameter parameter : method.getParameters()) {
            if (!parameter.getBaseType().equals(InjectionPoint.class)) continue;
            return true;
        }
        return false;
    }

    private static <T> T getReference(BeanManager manager, Class<T> type) {
        return MetricCdiInjectionExtension.getReference(manager, type, manager.resolve(manager.getBeans(type, new Annotation[0])));
    }

    private static <T> T getReference(BeanManager manager, Type type, Bean<?> bean) {
        return (T)manager.getReference(bean, type, manager.createCreationalContext(bean));
    }
}

