package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.List;

/**
 * An interface that represents the execution result of an operation on the database server.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.SqlResult original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.SqlResult.class)
public class SqlResult<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<SqlResult> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new SqlResult((io.vertx.sqlclient.SqlResult) obj),
    SqlResult::getDelegate
  );

  private final io.vertx.sqlclient.SqlResult<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public SqlResult(io.vertx.sqlclient.SqlResult delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public SqlResult(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.sqlclient.SqlResult)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public SqlResult(io.vertx.sqlclient.SqlResult delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  SqlResult() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.sqlclient.SqlResult getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.desc.ColumnDescriptor> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.sqlclient.desc.ColumnDescriptor>(o1 -> io.vertx.mutiny.sqlclient.desc.ColumnDescriptor.newInstance((io.vertx.sqlclient.desc.ColumnDescriptor)o1), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SqlResult that = (SqlResult) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the count of affected rows.
   */
  public int rowCount() { 
    int ret = delegate.rowCount();
    return ret;
  }

  /**
   * @return the list of names of columns.
   */
  public List<String> columnsNames() { 
    List<String> ret = delegate.columnsNames();
    return ret;
  }

  /**
   * @return the list of column descriptors
   */
  public List<io.vertx.mutiny.sqlclient.desc.ColumnDescriptor> columnDescriptors() { 
    List<io.vertx.mutiny.sqlclient.desc.ColumnDescriptor> ret = delegate.columnDescriptors().stream().map(elt -> io.vertx.mutiny.sqlclient.desc.ColumnDescriptor.newInstance((io.vertx.sqlclient.desc.ColumnDescriptor)elt)).collect(java.util.stream.Collectors.toList());
    return ret;
  }

  /**
   * @return the count of rows.
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  /**
   * @param propertyKind the unique object which is used to indicate which property of the execution result to fetch
   * @return the value of the property
   */
  public <V> V property(io.vertx.mutiny.sqlclient.PropertyKind<V> propertyKind) { 
    V ret = (V)propertyKind.__typeArg_0.wrap(delegate.property(propertyKind.getDelegate()));
    return ret;
  }

  /**
   * @return the result value
   */
  public T value() { 
    T ret = (T)__typeArg_0.wrap(delegate.value());
    return ret;
  }

  /**
   * @return the next available result or <code>null</code> if none is available
   */
  public io.vertx.mutiny.sqlclient.SqlResult<T> next() { 
    io.vertx.mutiny.sqlclient.SqlResult<T> ret = io.vertx.mutiny.sqlclient.SqlResult.newInstance((io.vertx.sqlclient.SqlResult)delegate.next(), __typeArg_0);
    return ret;
  }

  public static <T>SqlResult<T> newInstance(io.vertx.sqlclient.SqlResult arg) {
    return arg != null ? new SqlResult<T>(arg) : null;
  }


  public static <T>SqlResult<T> newInstance(io.vertx.sqlclient.SqlResult arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new SqlResult<T>(arg, __typeArg_T) : null;
  }

}
