package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * The execution result of the row set of a query provided as <code><R></code>, commonly used as a <code>RowSet<Row></code>.
 * Using a collector query might provide a different result.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.RowSet original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.RowSet.class)
public class RowSet<R> extends io.vertx.mutiny.sqlclient.SqlResult<io.vertx.mutiny.sqlclient.RowSet<R>> implements java.lang.Iterable<R> {

  public static final io.smallrye.mutiny.vertx.TypeArg<RowSet> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new RowSet((io.vertx.sqlclient.RowSet) obj),
    RowSet::getDelegate
  );

  private final io.vertx.sqlclient.RowSet<R> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<R> __typeArg_0;
  
  public RowSet(io.vertx.sqlclient.RowSet delegate) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public RowSet(Object delegate, TypeArg<R> typeArg_0) {
    super((io.vertx.sqlclient.RowSet)delegate);
    this.delegate = (io.vertx.sqlclient.RowSet)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public RowSet(io.vertx.sqlclient.RowSet delegate, io.smallrye.mutiny.vertx.TypeArg<R> typeArg_0) {
    super(delegate);
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  RowSet() {
    super(null);
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.sqlclient.RowSet getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    RowSet that = (RowSet) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  @CheckReturnValue
  public Multi<R> toMulti() {
    return Multi.createFrom().iterable(this);
  }

  /**
   * @return the result value
   */
  public io.vertx.mutiny.sqlclient.RowSet<R> value() { 
    io.vertx.mutiny.sqlclient.RowSet<R> ret = io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)delegate.value(), __typeArg_0);
    return ret;
  }

  public io.vertx.mutiny.sqlclient.RowIterator<R> iterator() { 
    io.vertx.mutiny.sqlclient.RowIterator<R> ret = io.vertx.mutiny.sqlclient.RowIterator.newInstance((io.vertx.sqlclient.RowIterator)delegate.iterator(), __typeArg_0);
    return ret;
  }

  public io.vertx.mutiny.sqlclient.RowSet<R> next() { 
    io.vertx.mutiny.sqlclient.RowSet<R> ret = io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)delegate.next(), __typeArg_0);
    return ret;
  }

  public static <R>RowSet<R> newInstance(io.vertx.sqlclient.RowSet arg) {
    return arg != null ? new RowSet<R>(arg) : null;
  }


  public static <R>RowSet<R> newInstance(io.vertx.sqlclient.RowSet arg, io.smallrye.mutiny.vertx.TypeArg<R> __typeArg_R) {
    return arg != null ? new RowSet<R>(arg, __typeArg_R) : null;
  }

}
