package io.vertx.mutiny.sqlclient;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.core.Future;
import java.util.function.Function;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.TransactionPropagation;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A connection pool which reuses a number of SQL connections.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.sqlclient.Pool original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.sqlclient.Pool.class)
public class Pool extends io.vertx.mutiny.sqlclient.SqlClient {

  public static final io.smallrye.mutiny.vertx.TypeArg<Pool> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Pool((io.vertx.sqlclient.Pool) obj),
    Pool::getDelegate
  );

  private final io.vertx.sqlclient.Pool delegate;
  
  public Pool(io.vertx.sqlclient.Pool delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public Pool(Object delegate) {
    super((io.vertx.sqlclient.Pool)delegate);
    this.delegate = (io.vertx.sqlclient.Pool)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Pool() {
    super(null);
    this.delegate = null;
  }

  public io.vertx.sqlclient.Pool getDelegate() {
    return delegate;
  }

  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> TYPE_ARG_0 = new TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>>(o1 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.mutiny.sqlclient.Row>(o2 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  static final io.smallrye.mutiny.vertx.TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> TYPE_ARG_1 = new TypeArg<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>>(o1 -> io.vertx.mutiny.sqlclient.RowSet.newInstance((io.vertx.sqlclient.RowSet)o1, new TypeArg<io.vertx.mutiny.sqlclient.Row>(o2 -> io.vertx.mutiny.sqlclient.Row.newInstance((io.vertx.sqlclient.Row)o2), o2 -> o2.getDelegate())), o1 -> o1.getDelegate());
  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Pool that = (Pool) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param connectOptions 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.Pool pool(io.vertx.sqlclient.SqlConnectOptions connectOptions) { 
    io.vertx.mutiny.sqlclient.Pool ret = io.vertx.mutiny.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(connectOptions));
    return ret;
  }

  /**
   * @param database 
   * @param options 
   * @return 
   */
  public static io.vertx.mutiny.sqlclient.Pool pool(io.vertx.sqlclient.SqlConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.Pool ret = io.vertx.mutiny.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(database, options));
    return ret;
  }

  /**
   * @param vertx the Vertx instance to be used with the connection pool
   * @param database the options used to create the connection pool, such as database hostname
   * @param options the options for creating the pool
   * @return the connection pool
   */
  public static io.vertx.mutiny.sqlclient.Pool pool(io.vertx.mutiny.core.Vertx vertx, io.vertx.sqlclient.SqlConnectOptions database, io.vertx.sqlclient.PoolOptions options) { 
    io.vertx.mutiny.sqlclient.Pool ret = io.vertx.mutiny.sqlclient.Pool.newInstance((io.vertx.sqlclient.Pool)io.vertx.sqlclient.Pool.pool(vertx.getDelegate(), database, options));
    return ret;
  }

  /**
   * Get a connection from the pool.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.SqlConnection> getConnection() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.getConnection(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, ar -> ar.map(event -> io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Pool#getConnection}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the SqlConnection instance produced by the operation.
   */
  public io.vertx.mutiny.sqlclient.SqlConnection getConnectionAndAwait() { 
    return (io.vertx.mutiny.sqlclient.SqlConnection) getConnection().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Pool#getConnection} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Pool#getConnection}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Pool#getConnection} but you don't need to compose it with other operations.
   */
  public void getConnectionAndForget() { 
    getConnection().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param sql 
   * @return 
   */
  public io.vertx.mutiny.sqlclient.Query<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> query(String sql) { 
    io.vertx.mutiny.sqlclient.Query<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> ret = io.vertx.mutiny.sqlclient.Query.newInstance((io.vertx.sqlclient.Query)delegate.query(sql), TYPE_ARG_0);
    return ret;
  }

  /**
   * @param sql 
   * @return 
   */
  public io.vertx.mutiny.sqlclient.PreparedQuery<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> preparedQuery(String sql) { 
    io.vertx.mutiny.sqlclient.PreparedQuery<io.vertx.mutiny.sqlclient.RowSet<io.vertx.mutiny.sqlclient.Row>> ret = io.vertx.mutiny.sqlclient.PreparedQuery.newInstance((io.vertx.sqlclient.PreparedQuery)delegate.preparedQuery(sql), TYPE_ARG_1);
    return ret;
  }

  /**
   * Execute the given <code>function</code> within a transaction.
   *
   * <p>The <code>function</code> is passed a client executing all operations within a transaction.
   * When the future returned by the function
   * <ul>
   *   <li>succeeds the transaction commits</li>
   *   <li>fails the transaction rollbacks</li>
   * </ul>
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures and the transaction commits.
   * Otherwise it is given a failure result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param function the code to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public <T> io.smallrye.mutiny.Uni<T> withTransaction(Function<io.vertx.mutiny.sqlclient.SqlConnection, io.smallrye.mutiny.Uni<T>> function) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.withTransaction(new java.util.function.Function<io.vertx.sqlclient.SqlConnection,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 function.apply(io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)arg))
            );
         }
     }, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Pool#withTransaction(Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param function the code to execute
   * @return the T instance produced by the operation.
   */
  public <T> T withTransactionAndAwait(Function<io.vertx.mutiny.sqlclient.SqlConnection, io.smallrye.mutiny.Uni<T>> function) { 
    return (T) withTransaction(function).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Pool#withTransaction(Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Pool#withTransaction(Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Pool#withTransaction(Function)} but you don't need to compose it with other operations.
   * @param function the code to execute
   */
  public <T> void withTransactionAndForget(Function<io.vertx.mutiny.sqlclient.SqlConnection, io.smallrye.mutiny.Uni<T>> function) { 
    withTransaction(function).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.sqlclient.Pool#withTransaction} but allows for setting the mode, defining how the acquired
   * connection is managed during the execution of the function.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param txPropagation 
   * @param function 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public <T> io.smallrye.mutiny.Uni<T> withTransaction(io.vertx.sqlclient.TransactionPropagation txPropagation, Function<io.vertx.mutiny.sqlclient.SqlConnection, io.smallrye.mutiny.Uni<T>> function) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.withTransaction(txPropagation, new java.util.function.Function<io.vertx.sqlclient.SqlConnection,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 function.apply(io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)arg))
            );
         }
     }, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Pool#withTransaction(TransactionPropagation,Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param txPropagation 
   * @param function 
   * @return the T instance produced by the operation.
   */
  public <T> T withTransactionAndAwait(io.vertx.sqlclient.TransactionPropagation txPropagation, Function<io.vertx.mutiny.sqlclient.SqlConnection, io.smallrye.mutiny.Uni<T>> function) { 
    return (T) withTransaction(txPropagation, function).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Pool#withTransaction(TransactionPropagation,Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Pool#withTransaction(TransactionPropagation,Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Pool#withTransaction(TransactionPropagation,Function)} but you don't need to compose it with other operations.
   * @param txPropagation 
   * @param function 
   */
  public <T> void withTransactionAndForget(io.vertx.sqlclient.TransactionPropagation txPropagation, Function<io.vertx.mutiny.sqlclient.SqlConnection, io.smallrye.mutiny.Uni<T>> function) { 
    withTransaction(txPropagation, function).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Get a connection from the pool and execute the given <code>function</code>.
   *
   * <p> When the future returned by the <code>function</code> completes, the connection is returned to the pool.
   *
   * <p>The <code>handler</code> is given a success result when the function returns a succeeded futures.
   * Otherwise it is given a failure result.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param function the code to execute
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public <T> io.smallrye.mutiny.Uni<T> withConnection(Function<io.vertx.mutiny.sqlclient.SqlConnection, io.smallrye.mutiny.Uni<T>> function) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.withConnection(new java.util.function.Function<io.vertx.sqlclient.SqlConnection,io.vertx.core.Future<T>>() {
      public io.vertx.core.Future<T> apply(io.vertx.sqlclient.SqlConnection arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 function.apply(io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)arg))
            );
         }
     }, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.Pool#withConnection(Function)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param function the code to execute
   * @return the T instance produced by the operation.
   */
  public <T> T withConnectionAndAwait(Function<io.vertx.mutiny.sqlclient.SqlConnection, io.smallrye.mutiny.Uni<T>> function) { 
    return (T) withConnection(function).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.Pool#withConnection(Function)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.Pool#withConnection(Function)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.Pool#withConnection(Function)} but you don't need to compose it with other operations.
   * @param function the code to execute
   */
  public <T> void withConnectionAndForget(Function<io.vertx.mutiny.sqlclient.SqlConnection, io.smallrye.mutiny.Uni<T>> function) { 
    withConnection(function).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Close the pool and release the associated resources.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.sqlclient.SqlClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.sqlclient.SqlClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.sqlclient.SqlClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.sqlclient.SqlClient#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * @param handler the handler
   * @return a reference to this, so the API can be used fluently
   * @deprecated instead use {@link ClientBuilder#withConnectHandler(Handler)}   */
  @Deprecated
  @Fluent
  private io.vertx.mutiny.sqlclient.Pool __connectHandler(Handler<io.vertx.mutiny.sqlclient.SqlConnection> handler) { 
    delegate.connectHandler(new io.smallrye.mutiny.vertx.DelegatingHandler<>(handler, event -> io.vertx.mutiny.sqlclient.SqlConnection.newInstance((io.vertx.sqlclient.SqlConnection)event)));
    return this;
  }

  /**
   * @param handler the handler
   * @return 
   * @deprecated instead use {@link ClientBuilder#withConnectHandler(Handler)}   */
  @Deprecated
  public io.vertx.mutiny.sqlclient.Pool connectHandler(java.util.function.Consumer<io.vertx.mutiny.sqlclient.SqlConnection> handler) {
    return __connectHandler(handler != null ? new io.smallrye.mutiny.vertx.DelegatingConsumerHandler(handler) : null);
  }

  /**
   * @param provider the new connection provider
   * @return a reference to this, so the API can be used fluently
   * @deprecated instead use {@link ClientBuilder#connectingTo(Supplier)}   */
  @Deprecated
  @Fluent
  public io.vertx.mutiny.sqlclient.Pool connectionProvider(Function<io.vertx.mutiny.core.Context, io.smallrye.mutiny.Uni<io.vertx.mutiny.sqlclient.SqlConnection>> provider) { 
    delegate.connectionProvider(new java.util.function.Function<io.vertx.core.Context,io.vertx.core.Future<io.vertx.sqlclient.SqlConnection>>() {
      public io.vertx.core.Future<io.vertx.sqlclient.SqlConnection> apply(io.vertx.core.Context arg) {
            return io.smallrye.mutiny.vertx.UniHelper.toFuture(
                 provider.apply(io.vertx.mutiny.core.Context.newInstance((io.vertx.core.Context)arg)).map(x -> x.getDelegate())
            );
         }
     });
    return this;
  }

  /**
   * @return the current pool size approximation
   */
  public int size() { 
    int ret = delegate.size();
    return ret;
  }

  public static  Pool newInstance(io.vertx.sqlclient.Pool arg) {
    return arg != null ? new Pool(arg) : null;
  }

}
