/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.math;

import io.smallrye.mutiny.Multi;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public class MaxOperator<T extends Comparable<T>>
implements Function<Multi<T>, Multi<T>> {
    private final AtomicReference<T> max = new AtomicReference();

    @Override
    public Multi<T> apply(Multi<T> multi) {
        return multi.onItem().transformToMultiAndConcatenate(item -> {
            if (this.max.compareAndSet(null, item)) {
                return Multi.createFrom().item(item);
            }
            if (item == this.max.updateAndGet(t -> {
                if (t.compareTo(item) < 0) {
                    return item;
                }
                return t;
            })) {
                return Multi.createFrom().item(item);
            }
            return Multi.createFrom().empty();
        }).skip().repetitions();
    }
}

