/*
 * Decompiled with CFR 0.152.
 */
package kos.core.validation;

import injector.Exposed;
import kos.api.ExceptionHandler;
import kos.api.ImplementationLoader;
import kos.api.MutableKosContext;
import kos.api.Plugin;
import kos.api.Validation;
import kos.core.exception.PredicateExceptionHandler;
import kos.core.validation.DefaultValidation;
import kos.core.validation.ValidationException;
import kos.core.validation.ValidationExceptionHandler;

@Exposed
public class ValidationPlugin
implements Plugin {
    @Override
    public void configure(MutableKosContext mutableKosContext) {
        this.configureDefaultValidation(mutableKosContext);
        this.registerExceptionHandler(mutableKosContext);
    }

    private void configureDefaultValidation(MutableKosContext mutableKosContext) {
        Validation validation = mutableKosContext.getDefaultValidation();
        if (!(validation instanceof DefaultValidation)) {
            return;
        }
        DefaultValidation defaultValidation = (DefaultValidation)validation;
        ImplementationLoader implementationLoader = mutableKosContext.getImplementationLoader();
        Iterable<Validation> iterable = implementationLoader.instancesExposedAs(Validation.class);
        for (Validation validation2 : iterable) {
            defaultValidation.memorise(validation2);
        }
        mutableKosContext.getImplementationLoader().register(Validation.class, defaultValidation);
    }

    private void registerExceptionHandler(MutableKosContext mutableKosContext) {
        ExceptionHandler exceptionHandler = mutableKosContext.getExceptionHandler();
        if (!(exceptionHandler instanceof PredicateExceptionHandler)) {
            return;
        }
        PredicateExceptionHandler predicateExceptionHandler = (PredicateExceptionHandler)exceptionHandler;
        predicateExceptionHandler.add(throwable -> throwable instanceof ValidationException, new ValidationExceptionHandler());
    }
}

