/*
 * Decompiled with CFR 0.152.
 */
package kos.core.exception;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import kos.api.ExceptionHandler;
import kos.api.Response;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PredicateExceptionHandler
implements ExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PredicateExceptionHandler.class);
    @NonNull
    final List<PredicateAndHandler> predicatesAndHandlers;

    public PredicateExceptionHandler() {
        this(new ArrayList<PredicateAndHandler>());
    }

    public void add(Predicate<Throwable> predicate, ExceptionHandler exceptionHandler) {
        this.predicatesAndHandlers.add(PredicateAndHandler.with(predicate, exceptionHandler));
    }

    @Override
    public Response handle(HttpServerRequest httpServerRequest, Throwable throwable) {
        for (PredicateAndHandler predicateAndHandler : this.predicatesAndHandlers) {
            if (!predicateAndHandler.predicate.test(throwable)) continue;
            return predicateAndHandler.handler.handle(httpServerRequest, throwable);
        }
        return this.handleUnknownError(httpServerRequest, throwable);
    }

    private Response handleUnknownError(HttpServerRequest httpServerRequest, Throwable throwable) {
        String string = String.format("Failed to handle request: %s - %s", httpServerRequest.method(), httpServerRequest.uri());
        log.error(string, throwable);
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Buffer buffer = Buffer.buffer((String)stringWriter.toString());
        return Response.wrap(buffer).statusCode(500).addHeader(HttpHeaders.CONTENT_TYPE, "text/plain");
    }

    @Generated
    public PredicateExceptionHandler(@NonNull List<PredicateAndHandler> list) {
        if (list == null) {
            throw new NullPointerException("predicatesAndHandlers is marked non-null but is null");
        }
        this.predicatesAndHandlers = list;
    }

    static class PredicateAndHandler {
        final Predicate<Throwable> predicate;
        final ExceptionHandler handler;

        @Generated
        private PredicateAndHandler(Predicate<Throwable> predicate, ExceptionHandler exceptionHandler) {
            this.predicate = predicate;
            this.handler = exceptionHandler;
        }

        @Generated
        public static PredicateAndHandler with(Predicate<Throwable> predicate, ExceptionHandler exceptionHandler) {
            return new PredicateAndHandler(predicate, exceptionHandler);
        }
    }
}

