/*
 * Decompiled with CFR 0.152.
 */
package kos.core.events;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.Message;
import java.util.function.Consumer;
import java.util.function.Function;
import kos.core.events.AsyncEventHandler;
import kos.core.events.DefaultAsyncEventReplier;
import kos.core.events.SyncEventHandler;

public interface EventHandler<T>
extends Handler<Message<T>> {
    default public void handle(Message<T> message) {
        this.tryHandle(message).onComplete(new DefaultAsyncEventReplier<T>(message));
    }

    public Future<Void> tryHandle(Message<T> var1);

    public static <T> EventHandler<T> sync(Consumer<Message<T>> consumer) {
        return new SyncEventHandler<T>(consumer);
    }

    public static <T> EventHandler<T> async(Function<Message<T>, Future<Void>> function) {
        return new AsyncEventHandler<T>(function);
    }
}

