/*
 * Decompiled with CFR 0.152.
 */
package kos.core.events;

import injector.AllOf;
import injector.Singleton;
import io.vertx.core.Handler;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageProducer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kos.api.EventBusSink;
import kos.api.EventPublisherSink;
import kos.api.EventSubscriptionSink;
import kos.api.KosContext;
import kos.core.Lang;
import kos.core.events.AlwaysConsistentMessageProducer;
import kos.core.exception.KosException;
import lombok.Generated;
import lombok.NonNull;

@Singleton
public class EventBusSinkManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Set<Class> classesWhichCodedHaveBeenRegistered = new HashSet<Class>();
    protected final KosContext kosContext;
    private final Iterable<EventSubscriptionSink> eventSubscriberSinks;
    private final Iterable<EventPublisherSink> eventPublisherSinks;

    public EventBusSinkManager(KosContext kosContext, @AllOf(value=EventSubscriptionSink.class) Iterable<EventSubscriptionSink> iterable, @AllOf(value=EventPublisherSink.class) Iterable<EventPublisherSink> iterable2) {
        this.kosContext = kosContext;
        this.eventSubscriberSinks = Lang.sorted(iterable, Comparator.comparing(EventBusSink::getPriority));
        this.eventPublisherSinks = Lang.sorted(iterable2, Comparator.comparing(EventBusSink::getPriority));
    }

    public <T> void subscribe(String string, Class<T> clazz, Handler<Message<T>> handler) {
        InitializationResult initializationResult = this.tryInitializeSink(string, clazz, this.eventSubscriberSinks);
        this.kosContext.getDefaultVertx().eventBus().consumer(initializationResult.rewrittenAddress, handler);
    }

    public <T> MessageProducer<T> createProducer(String string, Class<T> clazz) {
        EventBus eventBus = this.kosContext.getDefaultVertx().eventBus();
        InitializationResult initializationResult = this.tryInitializeSink(string, clazz, this.eventPublisherSinks);
        if (initializationResult.eventuallyConsistent.booleanValue()) {
            return eventBus.publisher(initializationResult.rewrittenAddress);
        }
        return new AlwaysConsistentMessageProducer(initializationResult.rewrittenAddress, eventBus);
    }

    final <T> InitializationResult tryInitializeSink(@NonNull String string, Class<T> clazz, Iterable<? extends EventBusSink> iterable) {
        if (string == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        try {
            this.ensureEventBusCanSerializeType(clazz);
            return this.performInitialization(string, clazz, iterable);
        }
        catch (KosException kosException) {
            throw kosException;
        }
        catch (Throwable throwable) {
            throw new KosException(throwable, "Failed to initialize Sync for " + string + ".", new Object[0]);
        }
    }

    private <T> InitializationResult performInitialization(@NonNull String string, Class<T> clazz, Iterable<? extends EventBusSink> iterable) {
        EventBusSink eventBusSink;
        if (string == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        EventBusSink.EventBusSyncInitializationRequest<T> eventBusSyncInitializationRequest = this.constructPublishingRequestFor(string, clazz);
        EventBusSink.Result result = EventBusSink.Result.NOT_ATTEMPTED;
        Iterator<? extends EventBusSink> iterator = iterable.iterator();
        while (iterator.hasNext() && !(result = (eventBusSink = iterator.next()).initialize(eventBusSyncInitializationRequest)).isInitialised()) {
            if (result.getFailureCause() == null) continue;
            throw new KosException("Failed to initialize Sync for " + string + ".", new Object[]{result.getFailureCause()});
        }
        if (!result.isInitialised()) {
            this.logger.debug((Object)("No custom EventBusSink was initialized for address '" + string + "."));
        }
        return new InitializationResult(result.getRewrittenAddressOr(string), result.isEventuallyConsistent());
    }

    private <T> EventBusSink.EventBusSyncInitializationRequest<T> constructPublishingRequestFor(String string, Class<T> clazz) {
        return new EventBusSink.EventBusSyncInitializationRequest<T>(this.kosContext.getApplicationConfig(), this.kosContext, string, clazz);
    }

    public <T> void ensureEventBusCanSerializeType(Class<T> clazz) {
        if (!this.classesWhichCodedHaveBeenRegistered.contains(clazz)) {
            EventBus eventBus = this.kosContext.getDefaultVertx().eventBus();
            MessageCodec<T, T> messageCodec = this.kosContext.getDefaultEventBusCodecFactory().constructCodecFor(clazz);
            eventBus.registerDefaultCodec(clazz, messageCodec);
            this.classesWhichCodedHaveBeenRegistered.add(clazz);
        }
    }

    static final class InitializationResult {
        private final String rewrittenAddress;
        private final Boolean eventuallyConsistent;

        @Generated
        public InitializationResult(String string, Boolean bl) {
            this.rewrittenAddress = string;
            this.eventuallyConsistent = bl;
        }

        @Generated
        public String getRewrittenAddress() {
            return this.rewrittenAddress;
        }

        @Generated
        public Boolean getEventuallyConsistent() {
            return this.eventuallyConsistent;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof InitializationResult)) {
                return false;
            }
            InitializationResult initializationResult = (InitializationResult)object;
            Boolean bl = this.getEventuallyConsistent();
            Boolean bl2 = initializationResult.getEventuallyConsistent();
            if (bl == null ? bl2 != null : !((Object)bl).equals(bl2)) {
                return false;
            }
            String string = this.getRewrittenAddress();
            String string2 = initializationResult.getRewrittenAddress();
            return !(string == null ? string2 != null : !string.equals(string2));
        }

        @Generated
        public int hashCode() {
            int n = 1;
            Boolean bl = this.getEventuallyConsistent();
            n = n * 59 + (bl == null ? 43 : ((Object)bl).hashCode());
            String string = this.getRewrittenAddress();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            return n;
        }

        @Generated
        public String toString() {
            return "EventBusSinkManager.InitializationResult(rewrittenAddress=" + this.getRewrittenAddress() + ", eventuallyConsistent=" + this.getEventuallyConsistent() + ")";
        }
    }
}

