/*
 * Decompiled with CFR 0.152.
 */
package kos.core.client;

import injector.Singleton;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kos.api.KosContext;
import kos.core.client.AutoGeneratedRestClientFactory;
import kos.core.client.RestClientConfiguration;
import kos.core.exception.KosException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class RestClientFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestClientFactory.class);
    private static final Function<Class, AutoGeneratedRestClientFactory> NOT_FOUND = clazz -> {
        throw new KosException("No client implementation found for " + clazz, new Object[0]);
    };
    final Map<Class, AutoGeneratedRestClientFactory> factories = new HashMap<Class, AutoGeneratedRestClientFactory>();
    final KosContext kosContext;

    public RestClientFactory(KosContext kosContext) {
        Iterable<AutoGeneratedRestClientFactory> iterable = kosContext.getImplementationLoader().instancesExposedAs(AutoGeneratedRestClientFactory.class);
        for (AutoGeneratedRestClientFactory autoGeneratedRestClientFactory : iterable) {
            this.factories.put(autoGeneratedRestClientFactory.getClientType(), autoGeneratedRestClientFactory);
        }
        this.kosContext = kosContext;
    }

    public <T> T instantiate(RestClientConfiguration restClientConfiguration, Class<T> clazz) {
        RestClientConfiguration restClientConfiguration2 = restClientConfiguration.useDefaultsForNullProperties(this.kosContext);
        return this.factories.computeIfAbsent(clazz, NOT_FOUND).initialize(restClientConfiguration2);
    }

    public void register(AutoGeneratedRestClientFactory autoGeneratedRestClientFactory) {
        AutoGeneratedRestClientFactory autoGeneratedRestClientFactory2 = this.factories.putIfAbsent(autoGeneratedRestClientFactory.getClientType(), autoGeneratedRestClientFactory);
        if (autoGeneratedRestClientFactory2 != null) {
            log.warn("Replaced " + autoGeneratedRestClientFactory2.getClass().getCanonicalName() + " with " + autoGeneratedRestClientFactory.getClass().getCanonicalName() + " as factory for Rest Client " + autoGeneratedRestClientFactory.getClientType().getCanonicalName());
        }
    }
}

