/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import injector.Singleton;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import kos.api.KosContext;

@Singleton
public class VertxFutures {
    final Vertx vertx;

    public VertxFutures(KosContext kosContext) {
        this.vertx = kosContext.getDefaultVertx();
    }

    public <T> io.vertx.core.Future<T> asFuture(io.vertx.core.Future<T> future) {
        return future;
    }

    public <T> io.vertx.core.Future<T> asFuture(CompletableFuture<T> completableFuture) {
        Promise promise = Promise.promise();
        completableFuture.handleAsync((object, throwable) -> {
            if (throwable == null) {
                promise.complete(object);
            } else {
                promise.fail(throwable);
            }
            return null;
        }, (Executor)this.vertx.nettyEventLoopGroup());
        return promise.future();
    }

    public <T> io.vertx.core.Future<T> asFuture(Future<T> future) {
        Promise promise2 = Promise.promise();
        this.vertx.executeBlocking(promise -> {
            try {
                Object v = future.get();
                promise.complete(v);
            }
            catch (Throwable throwable) {
                promise.fail(throwable);
            }
        }, (Handler)promise2);
        return promise2.future();
    }

    public <T> io.vertx.core.Future<T> asFuture(T t) {
        return io.vertx.core.Future.succeededFuture(t);
    }
}

