/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import kos.api.ConfigurationLoadedEventListener;
import kos.api.KosContext;
import kos.api.MutableKosContext;
import kos.api.Plugin;
import kos.core.Lang;
import kos.core.VertxWebServer;
import kos.core.exception.KosException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Launcher.class);
    private final MutableKosContext conf;

    public Launcher() {
        this(new MutableKosContext());
    }

    public static void main(String[] stringArray) {
        new Launcher().run();
    }

    public void run() {
        this.runPluginsAndConfigureKos();
        this.readDeploymentConfig((Handler<ConfigurationLoadedEventListener.ConfigurationLoadedEvent>)((Handler)configurationLoadedEvent -> {
            this.trigger((ConfigurationLoadedEventListener.ConfigurationLoadedEvent)configurationLoadedEvent);
            this.deployWebServer((ConfigurationLoadedEventListener.ConfigurationLoadedEvent)configurationLoadedEvent);
            this.deployVerticles((ConfigurationLoadedEventListener.ConfigurationLoadedEvent)configurationLoadedEvent);
        }));
    }

    private void runPluginsAndConfigureKos() {
        log.info("Initializing plugins...");
        Iterable<Plugin> iterable = Lang.sorted(this.conf.getSpi().instancesExposedAs(Plugin.class), (plugin, plugin2) -> Integer.compare(plugin2.priority(), plugin.priority()));
        for (Plugin plugin3 : iterable) {
            log.debug(" -> " + plugin3.getClass().getCanonicalName());
            plugin3.configure(this.conf);
        }
        this.conf.getImplementationLoader().register(KosContext.class, this.conf);
    }

    void readDeploymentConfig(Handler<ConfigurationLoadedEventListener.ConfigurationLoadedEvent> handler) {
        log.info("Reading deployment configuration...");
        this.conf.getConfigRetriever().getConfig(asyncResult -> {
            if (!asyncResult.succeeded()) {
                throw new KosException("Failed to read configuration", new Object[]{asyncResult.cause()});
            }
            this.conf.setApplicationConfig((JsonObject)asyncResult.result());
            ConfigurationLoadedEventListener.ConfigurationLoadedEvent configurationLoadedEvent = new ConfigurationLoadedEventListener.ConfigurationLoadedEvent(this.conf, (JsonObject)asyncResult.result());
            handler.handle((Object)configurationLoadedEvent);
        });
    }

    void trigger(ConfigurationLoadedEventListener.ConfigurationLoadedEvent configurationLoadedEvent) {
        Iterable<ConfigurationLoadedEventListener> iterable = configurationLoadedEvent.getKosContext().getImplementationLoader().instancesExposedAs(ConfigurationLoadedEventListener.class);
        log.info("Configuration loaded.");
        for (ConfigurationLoadedEventListener configurationLoadedEventListener : iterable) {
            log.debug("Notifying " + configurationLoadedEventListener.getClass().getCanonicalName() + "...");
            configurationLoadedEventListener.on(configurationLoadedEvent);
        }
    }

    void deployWebServer(ConfigurationLoadedEventListener.ConfigurationLoadedEvent configurationLoadedEvent) {
        if (configurationLoadedEvent.getApplicationConfig().getBoolean("auto-config", Boolean.valueOf(true)).booleanValue()) {
            log.info("Deploying Vert.x WebServer...");
            VertxWebServer vertxWebServer = new VertxWebServer(configurationLoadedEvent.getKosContext());
            this.deploy(configurationLoadedEvent, (Verticle)vertxWebServer);
        }
    }

    void deployVerticles(ConfigurationLoadedEventListener.ConfigurationLoadedEvent configurationLoadedEvent) {
        log.info("Looking for verticles...");
        Iterable<Verticle> iterable = configurationLoadedEvent.getKosContext().getImplementationLoader().instancesExposedAs(Verticle.class);
        for (Verticle verticle : iterable) {
            this.deploy(configurationLoadedEvent, verticle);
        }
    }

    public void deploy(ConfigurationLoadedEventListener.ConfigurationLoadedEvent configurationLoadedEvent, Verticle verticle) {
        DeploymentOptions deploymentOptions = new DeploymentOptions().setConfig(configurationLoadedEvent.getApplicationConfig());
        log.debug("Deploying " + verticle.getClass().getCanonicalName() + "...");
        configurationLoadedEvent.getKosContext().getDefaultVertx().deployVerticle(verticle, deploymentOptions);
    }

    @Generated
    public Launcher(MutableKosContext mutableKosContext) {
        this.conf = mutableKosContext;
    }
}

