/*
 * Decompiled with CFR 0.152.
 */
package kos.api;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import java.util.HashMap;
import java.util.Map;
import kos.api.AbstractResponse;
import kos.api.KosContext;
import kos.api.Response;
import kos.api.Serializer;
import lombok.Generated;
import lombok.NonNull;

class SerializableResponse<T>
extends AbstractResponse {
    final T payload;

    public SerializableResponse(T t) {
        this(200, new HashMap<CharSequence, CharSequence>(), t);
    }

    private SerializableResponse(int n, @NonNull Map<CharSequence, CharSequence> map, T t) {
        super(n, map);
        if (map == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        this.payload = t;
    }

    @Override
    public Response addHeader(CharSequence charSequence, CharSequence charSequence2) {
        HashMap<CharSequence, CharSequence> hashMap = new HashMap<CharSequence, CharSequence>(this.headers);
        hashMap.put(charSequence, charSequence2);
        return new SerializableResponse<T>(this.statusCode, hashMap, this.payload);
    }

    @Override
    public void send(KosContext kosContext, HttpServerResponse httpServerResponse) {
        Serializer serializer = kosContext.getPayloadSerializationStrategy().serializerFor(httpServerResponse);
        Buffer buffer = serializer.serialize(this.payload);
        this.sendStatusAndHeader(httpServerResponse);
        httpServerResponse.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)serializer.contentType());
        httpServerResponse.end(buffer);
    }

    @Generated
    public String toString() {
        return "SerializableResponse(payload=" + this.payload + ")";
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SerializableResponse)) {
            return false;
        }
        SerializableResponse serializableResponse = (SerializableResponse)object;
        if (!serializableResponse.canEqual(this)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        T t = this.payload;
        T t2 = serializableResponse.payload;
        return !(t == null ? t2 != null : !t.equals(t2));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof SerializableResponse;
    }

    @Generated
    public int hashCode() {
        int n = super.hashCode();
        T t = this.payload;
        n = n * 59 + (t == null ? 43 : t.hashCode());
        return n;
    }
}

