/*
 * Decompiled with CFR 0.152.
 */
package kos.api;

import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClient;
import java.util.HashMap;
import java.util.Map;
import kos.api.EventBusMessageCodecFactory;
import kos.api.ExceptionHandler;
import kos.api.HeaderParserStrategy;
import kos.api.ImplementationLoader;
import kos.api.KosContext;
import kos.api.PayloadSerializationStrategy;
import kos.api.Serializer;
import kos.api.SingleSerializerStrategy;
import kos.api.StringConverter;
import kos.api.Validation;
import kos.core.Lang;
import kos.core.client.RestClientSerializer;
import kos.core.events.DefaultEventBusMessageCodecFactory;
import kos.core.exception.PredicateExceptionHandler;
import kos.core.validation.DefaultValidation;
import lombok.Generated;

public class MutableKosContext
implements KosContext {
    private final AvailablePayloadStrategies availablePayloadStrategies = new AvailablePayloadStrategies();
    private final Map<String, Serializer> serializers;
    private final Map<String, RestClientSerializer> restClientSerializers;
    private final ImplementationLoader spi;
    private ImplementationLoader implementationLoader;
    private PayloadSerializationStrategy payloadSerializationStrategy;
    private int defaultStatusForEmptyResponses = 204;
    private HttpServerOptions httpServerOptions;
    private Serializer defaultSerializer;
    private EventBusMessageCodecFactory defaultEventBusCodecFactory;
    private RestClientSerializer defaultRestClientSerializer;
    private Vertx defaultVertx;
    private WebClient defaultVertxWebClient;
    private StringConverter stringConverter;
    private ExceptionHandler exceptionHandler;
    private Validation defaultValidation;
    private ConfigRetriever configRetriever;
    private JsonObject applicationConfig;

    public MutableKosContext() {
        this(new ImplementationLoader.SPIImplementationLoader());
    }

    public MutableKosContext(ImplementationLoader implementationLoader) {
        this.spi = implementationLoader;
        this.restClientSerializers = this.loadRestClientSerializers();
        this.serializers = this.loadSerializers();
        this.implementationLoader = implementationLoader;
        this.defaultSerializer = this.getSerializers().get("application/json");
        this.defaultEventBusCodecFactory = new DefaultEventBusMessageCodecFactory();
        this.payloadSerializationStrategy = new SingleSerializerStrategy(this.getDefaultSerializer());
        this.httpServerOptions = new HttpServerOptions().setPort(9000);
        this.exceptionHandler = new PredicateExceptionHandler();
        this.defaultValidation = new DefaultValidation();
        this.stringConverter = new StringConverter.DefaultStringConverter();
        this.defaultRestClientSerializer = this.getRestClientSerializers().get("application/json");
    }

    @Override
    public ConfigRetriever getConfigRetriever() {
        if (this.configRetriever == null) {
            this.configRetriever = this.loadConfigRetriever();
        }
        return this.configRetriever;
    }

    private ConfigRetriever loadConfigRetriever() {
        ConfigRetrieverOptions configRetrieverOptions = new ConfigRetrieverOptions();
        return ConfigRetriever.create((Vertx)this.getDefaultVertx(), (ConfigRetrieverOptions)configRetrieverOptions);
    }

    @Override
    public Vertx getDefaultVertx() {
        if (this.defaultVertx == null) {
            this.defaultVertx = Vertx.vertx();
        }
        return this.defaultVertx;
    }

    @Override
    public WebClient getDefaultVertxWebClient() {
        if (this.defaultVertxWebClient == null) {
            this.defaultVertxWebClient = WebClient.create((Vertx)this.getDefaultVertx());
        }
        return this.defaultVertxWebClient;
    }

    private Map<String, Serializer> loadSerializers() {
        HashMap<String, Serializer> hashMap = new HashMap<String, Serializer>();
        Serializer.JsonSerializer jsonSerializer = new Serializer.JsonSerializer();
        hashMap.put(jsonSerializer.contentType(), jsonSerializer);
        Serializer.PlainTextSerializer plainTextSerializer = new Serializer.PlainTextSerializer(this);
        hashMap.put(plainTextSerializer.contentType(), plainTextSerializer);
        return hashMap;
    }

    private Map<String, RestClientSerializer> loadRestClientSerializers() {
        HashMap<String, RestClientSerializer> hashMap = new HashMap<String, RestClientSerializer>();
        RestClientSerializer.JsonRestClientSerializer jsonRestClientSerializer = new RestClientSerializer.JsonRestClientSerializer();
        hashMap.put(jsonRestClientSerializer.contentType(), jsonRestClientSerializer);
        return hashMap;
    }

    @Override
    public Serializer getSerializerForContentType(String string) {
        return this.getSerializers().computeIfAbsent(string, Serializer.INVALID_SERIALIZER);
    }

    @Override
    public JsonObject getApplicationConfig() {
        if (this.applicationConfig != null) {
            return this.applicationConfig;
        }
        Future future = Future.future(arg_0 -> ((ConfigRetriever)this.getConfigRetriever()).getConfig(arg_0));
        future.onComplete(asyncResult -> {
            if (asyncResult.succeeded()) {
                this.applicationConfig = (JsonObject)asyncResult.result();
            }
        });
        return (JsonObject)Lang.waitFor(future);
    }

    @Override
    public <T> Future<T> computeBlocking(KosContext.SupplierThatMightFail<T> supplierThatMightFail) {
        Promise promise2 = Promise.promise();
        this.getDefaultVertx().executeBlocking(promise -> {
            try {
                Object t = supplierThatMightFail.get();
                promise.complete(t);
            }
            catch (Throwable throwable) {
                promise.fail(throwable);
            }
        }, (Handler)promise2);
        return promise2.future();
    }

    @Override
    public Future<Void> runBlocking(KosContext.RunnerThatMightFail runnerThatMightFail) {
        Promise promise2 = Promise.promise();
        this.getDefaultVertx().executeBlocking(promise -> {
            try {
                runnerThatMightFail.run();
                promise.complete();
            }
            catch (Throwable throwable) {
                promise.fail(throwable);
            }
        }, (Handler)promise2);
        return promise2.future();
    }

    public String toString() {
        return "MutableKosContext{availablePayloadStrategies=" + this.availablePayloadStrategies + ", serializers=" + this.serializers + ", restClientSerializers=" + this.restClientSerializers + ", spi=" + this.spi + ", implementationLoader=" + this.implementationLoader + ", payloadSerializationStrategy=" + this.payloadSerializationStrategy + ", defaultStatusForEmptyResponses=" + this.defaultStatusForEmptyResponses + ", httpServerOptions=" + this.httpServerOptions + ", defaultSerializer=" + this.defaultSerializer + ", defaultRestClientSerializer=" + this.defaultRestClientSerializer + ", defaultVertx=" + this.defaultVertx + ", defaultVertxWebClient=" + this.defaultVertxWebClient + ", stringConverter=" + this.stringConverter + ", exceptionHandler=" + this.exceptionHandler + ", configRetriever=" + this.configRetriever + ", applicationConfig=" + this.applicationConfig + "}";
    }

    @Generated
    public AvailablePayloadStrategies getAvailablePayloadStrategies() {
        return this.availablePayloadStrategies;
    }

    @Generated
    public Map<String, Serializer> getSerializers() {
        return this.serializers;
    }

    @Generated
    public Map<String, RestClientSerializer> getRestClientSerializers() {
        return this.restClientSerializers;
    }

    @Override
    @Generated
    public ImplementationLoader getSpi() {
        return this.spi;
    }

    @Override
    @Generated
    public ImplementationLoader getImplementationLoader() {
        return this.implementationLoader;
    }

    @Override
    @Generated
    public PayloadSerializationStrategy getPayloadSerializationStrategy() {
        return this.payloadSerializationStrategy;
    }

    @Override
    @Generated
    public int getDefaultStatusForEmptyResponses() {
        return this.defaultStatusForEmptyResponses;
    }

    @Override
    @Generated
    public HttpServerOptions getHttpServerOptions() {
        return this.httpServerOptions;
    }

    @Override
    @Generated
    public Serializer getDefaultSerializer() {
        return this.defaultSerializer;
    }

    @Override
    @Generated
    public EventBusMessageCodecFactory getDefaultEventBusCodecFactory() {
        return this.defaultEventBusCodecFactory;
    }

    @Override
    @Generated
    public RestClientSerializer getDefaultRestClientSerializer() {
        return this.defaultRestClientSerializer;
    }

    @Override
    @Generated
    public StringConverter getStringConverter() {
        return this.stringConverter;
    }

    @Override
    @Generated
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    @Generated
    public Validation getDefaultValidation() {
        return this.defaultValidation;
    }

    @Generated
    public MutableKosContext setImplementationLoader(ImplementationLoader implementationLoader) {
        this.implementationLoader = implementationLoader;
        return this;
    }

    @Generated
    public MutableKosContext setPayloadSerializationStrategy(PayloadSerializationStrategy payloadSerializationStrategy) {
        this.payloadSerializationStrategy = payloadSerializationStrategy;
        return this;
    }

    @Generated
    public MutableKosContext setDefaultStatusForEmptyResponses(int n) {
        this.defaultStatusForEmptyResponses = n;
        return this;
    }

    @Generated
    public MutableKosContext setHttpServerOptions(HttpServerOptions httpServerOptions) {
        this.httpServerOptions = httpServerOptions;
        return this;
    }

    @Generated
    public MutableKosContext setDefaultSerializer(Serializer serializer) {
        this.defaultSerializer = serializer;
        return this;
    }

    @Generated
    public MutableKosContext setDefaultEventBusCodecFactory(EventBusMessageCodecFactory eventBusMessageCodecFactory) {
        this.defaultEventBusCodecFactory = eventBusMessageCodecFactory;
        return this;
    }

    @Generated
    public MutableKosContext setDefaultRestClientSerializer(RestClientSerializer restClientSerializer) {
        this.defaultRestClientSerializer = restClientSerializer;
        return this;
    }

    @Generated
    public MutableKosContext setDefaultVertx(Vertx vertx) {
        this.defaultVertx = vertx;
        return this;
    }

    @Generated
    public MutableKosContext setDefaultVertxWebClient(WebClient webClient) {
        this.defaultVertxWebClient = webClient;
        return this;
    }

    @Generated
    public MutableKosContext setStringConverter(StringConverter stringConverter) {
        this.stringConverter = stringConverter;
        return this;
    }

    @Generated
    public MutableKosContext setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    @Generated
    public MutableKosContext setDefaultValidation(Validation validation) {
        this.defaultValidation = validation;
        return this;
    }

    @Generated
    public MutableKosContext setConfigRetriever(ConfigRetriever configRetriever) {
        this.configRetriever = configRetriever;
        return this;
    }

    @Generated
    public MutableKosContext setApplicationConfig(JsonObject jsonObject) {
        this.applicationConfig = jsonObject;
        return this;
    }

    public class AvailablePayloadStrategies {
        public void useDefaultSerializer() {
            SingleSerializerStrategy singleSerializerStrategy = new SingleSerializerStrategy(MutableKosContext.this.getDefaultSerializer());
            MutableKosContext.this.setPayloadSerializationStrategy(singleSerializerStrategy);
        }

        public void useSerializerForContentType(String string) {
            Serializer serializer = MutableKosContext.this.getSerializerForContentType(string);
            SingleSerializerStrategy singleSerializerStrategy = new SingleSerializerStrategy(serializer);
            MutableKosContext.this.setPayloadSerializationStrategy(singleSerializerStrategy);
        }

        public void inferSerializerFromHttpHeader(String string) {
            MutableKosContext mutableKosContext = MutableKosContext.this;
            HeaderParserStrategy headerParserStrategy = new HeaderParserStrategy(mutableKosContext, HttpHeaders.CONTENT_TYPE, string);
            MutableKosContext.this.setPayloadSerializationStrategy(headerParserStrategy);
        }
    }
}

