/*
 * Decompiled with CFR 0.152.
 */
package kos.core.events;

import injector.AllOf;
import injector.Singleton;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kos.api.EventBusSink;
import kos.core.exception.KosException;

@Singleton
public class EventBusSinkManager
implements EventBusSink {
    private final Iterable<EventBusSink> sinks;
    private final Set<String> syncsAttemptedToBeInitialised = new HashSet<String>();

    EventBusSinkManager(@AllOf(value=EventBusSink.class) Iterable<EventBusSink> iterable) {
        this.sinks = iterable;
    }

    @Override
    public EventBusSink.Result tryInitialise(EventBusSink.SubscriptionRequest subscriptionRequest) {
        if (this.syncsAttemptedToBeInitialised.contains(subscriptionRequest.getAddress())) {
            return EventBusSink.Result.NOT_ATTEMPTED;
        }
        return this.performInitialization(subscriptionRequest);
    }

    private EventBusSink.Result performInitialization(EventBusSink.SubscriptionRequest subscriptionRequest) {
        EventBusSink eventBusSink;
        String string = subscriptionRequest.getAddress();
        EventBusSink.Result result = EventBusSink.Result.NOT_ATTEMPTED;
        Iterator<EventBusSink> iterator = this.sinks.iterator();
        while (iterator.hasNext() && !EventBusSink.Result.SUCCEEDED.equals(result = this.tryInitialiseSink(eventBusSink = iterator.next(), subscriptionRequest))) {
            if (result.getFailure() == null) continue;
            throw new KosException("Failed to initialize Sync for " + string + ".", new Object[]{result.getFailure()});
        }
        this.syncsAttemptedToBeInitialised.add(string);
        return result;
    }

    private EventBusSink.Result tryInitialiseSink(EventBusSink eventBusSink, EventBusSink.SubscriptionRequest subscriptionRequest) {
        try {
            return eventBusSink.tryInitialise(subscriptionRequest);
        }
        catch (Throwable throwable) {
            return EventBusSink.Result.failure(throwable);
        }
    }
}

