/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.Future;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import kos.api.ImplementationLoader;
import kos.core.exception.KosException;
import lombok.Generated;

public final class Lang {
    private Lang() {
    }

    public static <T> T instantiate(String string) {
        return Lang.instantiate(Lang.classFor(string));
    }

    public static <T> Class<T> classFor(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new KosException(classNotFoundException);
        }
    }

    public static <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new KosException(reflectiveOperationException);
        }
    }

    public static <T> T firstNotNull(T ... TArray) {
        for (T t : TArray) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static <T> ImplementationLoader.Result<T> first(Iterable<T> iterable) {
        return Lang.first(iterable, object -> true);
    }

    public static <T> boolean matches(Iterable<T> iterable, Predicate<T> predicate) {
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> ImplementationLoader.Result<T> first(Iterable<T> iterable, Predicate<T> predicate) {
        for (T t : iterable) {
            if (!predicate.test(t)) continue;
            return ImplementationLoader.Result.of(t);
        }
        return ImplementationLoader.Result.empty();
    }

    public static <T> List<T> filter(Collection<T> collection, Predicate<T> predicate) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : collection) {
            if (!predicate.test(t)) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T, N> List<N> convert(Iterable<T> iterable, Function<T, N> function) {
        ArrayList<N> arrayList = new ArrayList<N>();
        for (T t : iterable) {
            arrayList.add(function.apply(t));
        }
        return arrayList;
    }

    public static <T, N> List<N> convertIndex(Iterable<T> iterable, BiFunction<Integer, T, N> biFunction) {
        ArrayList<N> arrayList = new ArrayList<N>();
        int n = 0;
        for (T t : iterable) {
            arrayList.add(biFunction.apply(n++, (Integer)t));
        }
        return arrayList;
    }

    public static <K, V> MapBuilder<K, V> mapOf(K k, V v) {
        return new MapBuilder<K, V>().and(k, v);
    }

    public static List<String> nonEmptySetOfString(Iterable<String> iterable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : iterable) {
            if (string == null || string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static <T> Iterable<T> sorted(Iterable<T> iterable, Comparator<T> comparator) {
        ArrayList<T> arrayList = new ArrayList<T>();
        iterable.forEach(arrayList::add);
        arrayList.sort(comparator);
        return arrayList;
    }

    public static <T> T waitFor(Future<T> future) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        if (!stackTraceElement.getClassName().startsWith("kos.")) {
            throw new UnsupportedOperationException("Await was not designed for production usage");
        }
        while (!future.succeeded() && !future.failed()) {
            LockSupport.parkNanos(2L);
        }
        if (future.succeeded()) {
            return (T)future.result();
        }
        throw new KosException(future.cause().getMessage(), new Object[]{future.cause()});
    }

    public static <T> T waitFor(AtomicReference<T> atomicReference) {
        T t = null;
        while (true) {
            T t2 = atomicReference.get();
            t = t2;
            if (t2 != null) break;
            LockSupport.parkNanos(1L);
        }
        return t;
    }

    public static class MapBuilder<K, V> {
        final Map<K, V> data = new HashMap();

        public MapBuilder<K, V> and(K k, V v) {
            this.data.put(k, v);
            return this;
        }

        public Map<K, V> build() {
            return this.data;
        }

        @Generated
        private MapBuilder() {
        }
    }
}

