/*
 * Decompiled with CFR 0.152.
 */
package kos.core.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.ext.web.client.HttpResponse;
import lombok.Generated;

public interface RestClientSerializer {
    public String contentType();

    public Buffer serialize(Object var1);

    public <T> T deserialize(HttpResponse<Buffer> var1, Class<T> var2);

    public <T> T deserialize(HttpResponse<Buffer> var1, TypeReference<T> var2);

    public static class JsonRestClientSerializer
    implements RestClientSerializer {
        final String contentType = "application/json";

        @Override
        public Buffer serialize(Object object) {
            return Json.encodeToBuffer((Object)object);
        }

        @Override
        public <T> T deserialize(HttpResponse<Buffer> httpResponse, Class<T> clazz) {
            return (T)Json.decodeValue((Buffer)((Buffer)httpResponse.body()), clazz);
        }

        @Override
        public <T> T deserialize(HttpResponse<Buffer> httpResponse, TypeReference<T> typeReference) {
            return (T)Json.decodeValue((Buffer)((Buffer)httpResponse.body()), typeReference);
        }

        @Override
        @Generated
        public String contentType() {
            return this.contentType;
        }
    }
}

