/*
 * Decompiled with CFR 0.152.
 */
package kos.core.client;

import injector.Singleton;
import io.vertx.core.logging.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kos.api.KosContext;
import kos.core.KosException;
import kos.core.client.AutoGeneratedRestClientFactory;
import kos.core.client.RestClientConfiguration;

@Singleton
public class RestClientFactory {
    private static final Function<Class, AutoGeneratedRestClientFactory> NOT_FOUND = clazz -> {
        throw new KosException("No client implementation found for " + clazz, new Object[0]);
    };
    final Map<Class, AutoGeneratedRestClientFactory> factories = new HashMap<Class, AutoGeneratedRestClientFactory>();
    final Logger logger;
    final KosContext kosContext;

    public RestClientFactory(KosContext kosContext, Logger logger) {
        Iterable<AutoGeneratedRestClientFactory> iterable = kosContext.getImplementationLoader().instancesExposedAs(AutoGeneratedRestClientFactory.class);
        for (AutoGeneratedRestClientFactory autoGeneratedRestClientFactory : iterable) {
            this.factories.put(autoGeneratedRestClientFactory.getClientType(), autoGeneratedRestClientFactory);
        }
        this.logger = logger;
        this.kosContext = kosContext;
    }

    public <T> T instantiate(RestClientConfiguration restClientConfiguration, Class<T> clazz) {
        RestClientConfiguration restClientConfiguration2 = restClientConfiguration.useDefaultsForNullProperties(this.kosContext);
        return this.factories.computeIfAbsent(clazz, NOT_FOUND).initialize(restClientConfiguration2);
    }

    public void register(AutoGeneratedRestClientFactory autoGeneratedRestClientFactory) {
        AutoGeneratedRestClientFactory autoGeneratedRestClientFactory2 = this.factories.putIfAbsent(autoGeneratedRestClientFactory.getClientType(), autoGeneratedRestClientFactory);
        if (autoGeneratedRestClientFactory2 != null) {
            this.logger.fatal((Object)("Replaced " + autoGeneratedRestClientFactory2.getClass().getCanonicalName() + " with " + autoGeneratedRestClientFactory.getClass().getCanonicalName() + " as factory for Rest Client " + autoGeneratedRestClientFactory.getClientType().getCanonicalName()));
        }
    }
}

