/*
 * Decompiled with CFR 0.152.
 */
package kos.core.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import kos.core.client.ResponseHandler;
import kos.core.client.RestClientConfiguration;
import kos.core.client.RestClientSerializer;

public class AutoGeneratedRestClient {
    protected final RestClientConfiguration configuration;

    public AutoGeneratedRestClient(RestClientConfiguration restClientConfiguration) {
        this.configuration = restClientConfiguration;
    }

    protected MultiMap createEmptyHeaders() {
        return MultiMap.caseInsensitiveMultiMap().addAll(this.configuration.getHeaders());
    }

    public <T> Future<T> execute(HttpMethod httpMethod, String string, MultiMap multiMap, Class<T> clazz) {
        ResponseHandler<T> responseHandler = ResponseHandler.create(this.configuration.getRestClientSerializer(), clazz);
        return this.execute(httpMethod, string, multiMap, responseHandler);
    }

    public <T> Future<T> execute(HttpMethod httpMethod, String string, MultiMap multiMap, TypeReference<T> typeReference) {
        ResponseHandler<T> responseHandler = ResponseHandler.create(this.configuration.getRestClientSerializer(), typeReference);
        return this.execute(httpMethod, string, multiMap, responseHandler);
    }

    private <T> Future<T> execute(HttpMethod httpMethod, String string, MultiMap multiMap, ResponseHandler<T> responseHandler) {
        String string2 = this.configuration.getBaseUrl() + string;
        this.configuration.getClient().request(httpMethod, this.configuration.getPort(), this.configuration.getHost(), string2).ssl(Boolean.valueOf(this.configuration.isHttps())).putHeaders(multiMap).send(responseHandler);
        return responseHandler.future();
    }

    public <T> Future<T> send(HttpMethod httpMethod, String string, MultiMap multiMap, Object object, TypeReference<T> typeReference) {
        ResponseHandler<T> responseHandler = ResponseHandler.create(this.configuration.getRestClientSerializer(), typeReference);
        return this.send(httpMethod, string, multiMap, object, responseHandler);
    }

    public <T> Future<T> send(HttpMethod httpMethod, String string, MultiMap multiMap, Object object, Class<T> clazz) {
        ResponseHandler<T> responseHandler = ResponseHandler.create(this.configuration.getRestClientSerializer(), clazz);
        return this.send(httpMethod, string, multiMap, object, responseHandler);
    }

    protected <T> Future<T> send(HttpMethod httpMethod, String string, MultiMap multiMap, Object object, ResponseHandler<T> responseHandler) {
        RestClientSerializer restClientSerializer = this.configuration.getRestClientSerializer();
        multiMap.add("content-type", restClientSerializer.contentType());
        String string2 = this.configuration.getBaseUrl() + string;
        this.configuration.getClient().request(httpMethod, this.configuration.getPort(), this.configuration.getHost(), string2).ssl(Boolean.valueOf(this.configuration.isHttps())).putHeaders(multiMap).sendBuffer(restClientSerializer.serialize(object), responseHandler);
        return responseHandler.future();
    }
}

