/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.json.Json;
import io.vertx.core.logging.Logger;
import io.vertx.ext.web.Router;
import java.util.Comparator;
import kos.api.KosContext;
import kos.api.RequestInterceptor;
import kos.api.WebServerEventListener;
import kos.core.DefaultContextAttributesMemorizer;
import kos.core.Lang;
import kos.core.SimplifiedRouter;
import lombok.Generated;
import lombok.NonNull;

public class VertxWebServer
extends AbstractVerticle {
    private final Logger log;
    private final KosContext kosContext;
    @NonNull
    private SimplifiedRouter router;

    public VertxWebServer(KosContext kosContext) {
        this(kosContext, true);
    }

    public VertxWebServer(KosContext kosContext, boolean bl) {
        this(kosContext, VertxWebServer.loadDefaultRouter(kosContext, bl));
    }

    private static SimplifiedRouter loadDefaultRouter(KosContext kosContext, boolean bl) {
        Router router = Router.router((Vertx)kosContext.getDefaultVertx());
        SimplifiedRouter simplifiedRouter = SimplifiedRouter.wrapWithAutoBodyReader(kosContext, router);
        if (bl) {
            router.route().handler((Handler)new DefaultContextAttributesMemorizer());
            kosContext.getImplementationLoader().instancesExposedAs(RequestInterceptor.class).forEach(simplifiedRouter::intercept);
        }
        return simplifiedRouter;
    }

    public VertxWebServer(KosContext kosContext, SimplifiedRouter simplifiedRouter) {
        this.log = kosContext.createLoggerFor(((Object)((Object)this)).getClass());
        this.kosContext = kosContext;
        this.router = simplifiedRouter;
    }

    public void start() {
        this.start((Promise<Void>)Promise.promise());
    }

    public void start(Promise<Void> promise) {
        try {
            this.beforeStart();
            this.startServer(promise);
            promise.complete();
        }
        catch (Throwable throwable) {
            this.log.error((Object)"Could not start server", throwable);
            promise.fail(throwable);
        }
    }

    private void startServer(Promise<Void> promise) {
        this.notifyWebServerDeploymentListeners();
        this.vertx.createHttpServer(this.kosContext.getHttpServerOptions()).requestHandler((Handler)this.router()).listen(asyncResult -> {
            if (asyncResult.failed()) {
                promise.fail(asyncResult.cause());
            } else {
                HttpServer httpServer = (HttpServer)asyncResult.result();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> ((HttpServer)httpServer).close()));
                this.afterStart(httpServer);
            }
        });
    }

    private void notifyWebServerDeploymentListeners() {
        WebServerEventListener.BeforeDeployWebServerEvent beforeDeployWebServerEvent = new WebServerEventListener.BeforeDeployWebServerEvent(this.vertx, this.router(), this.config(), this.kosContext);
        Iterable<WebServerEventListener> iterable = this.kosContext.getImplementationLoader().instancesExposedAs(WebServerEventListener.class);
        Lang.sorted(iterable, Comparator.comparingInt(WebServerEventListener::priority).reversed()).forEach(webServerEventListener -> webServerEventListener.on(beforeDeployWebServerEvent));
    }

    protected void beforeStart() {
        Json.mapper.findAndRegisterModules();
        Json.prettyMapper.findAndRegisterModules();
    }

    protected void afterStart(HttpServer httpServer) {
        this.log.info((Object)("Server started at " + httpServer.actualPort() + " port"));
    }

    @Generated
    public VertxWebServer router(@NonNull SimplifiedRouter simplifiedRouter) {
        if (simplifiedRouter == null) {
            throw new NullPointerException("router is marked non-null but is null");
        }
        this.router = simplifiedRouter;
        return this;
    }

    @Generated
    public Logger log() {
        return this.log;
    }

    @Generated
    public KosContext kosContext() {
        return this.kosContext;
    }

    @NonNull
    @Generated
    public SimplifiedRouter router() {
        return this.router;
    }
}

