/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Collections;
import java.util.Map;
import kos.api.KosContext;
import kos.api.RequestHandler;
import kos.api.RequestInterceptor;
import kos.api.Response;
import kos.core.Lang;
import kos.core.RequestInterceptorHandler;
import lombok.Generated;

public class SimplifiedRouter
implements Handler<HttpServerRequest> {
    private final Logger log;
    private final Router router;
    private final RequestInterceptorHandler interceptorHandler;
    private final Map<HttpMethod, Boolean> httpMethodsThatMayReadBody;
    private final KosContext kosContext;

    public SimplifiedRouter(KosContext kosContext, Router router, Map<HttpMethod, Boolean> map) {
        this(kosContext, router, new RequestInterceptorHandler((Handler<HttpServerRequest>)router), map);
    }

    private SimplifiedRouter(KosContext kosContext, Router router, RequestInterceptorHandler requestInterceptorHandler, Map<HttpMethod, Boolean> map) {
        this.interceptorHandler = requestInterceptorHandler;
        this.router = router;
        this.httpMethodsThatMayReadBody = map;
        this.log = kosContext.createLoggerFor(this.getClass());
        this.kosContext = kosContext;
    }

    public Router unwrap() {
        return this.router;
    }

    public void intercept(RequestInterceptor requestInterceptor) {
        this.intercept(requestInterceptor, true);
    }

    public void intercept(RequestInterceptor requestInterceptor, boolean bl) {
        this.log.info((Object)("Registering router interceptor " + requestInterceptor.getClass().getCanonicalName()));
        if (bl) {
            requestInterceptor = new SafeRequestInterceptor(requestInterceptor, this.kosContext);
        }
        this.interceptorHandler.register(requestInterceptor);
    }

    public void intercept(Handler<RoutingContext> handler) {
        this.log.info((Object)("Registering router interceptor " + handler.getClass().getCanonicalName()));
        SafeRoutingContextHandler safeRoutingContextHandler = new SafeRoutingContextHandler(handler, this.kosContext);
        this.router.route().handler((Handler)safeRoutingContextHandler);
    }

    public void route(HttpMethod httpMethod, String string, RequestHandler requestHandler) {
        this.route(httpMethod, string, (Handler<RoutingContext>)requestHandler);
    }

    public void route(HttpMethod httpMethod, String string, Handler<RoutingContext> handler) {
        this.log.info((Object)("Registering router " + httpMethod + " " + string));
        boolean bl = this.httpMethodsThatMayReadBody.replace(httpMethod, false, true);
        if (bl) {
            this.router.route().method(httpMethod).handler((Handler)BodyHandler.create());
        }
        this.router.route(httpMethod, string).handler((Handler)new SafeRoutingContextHandler(handler, this.kosContext));
        this.log.debug((Object)("Registered " + handler.getClass()));
    }

    public static SimplifiedRouter wrapWithAutoBodyReader(KosContext kosContext, Router router) {
        Map<HttpMethod, Boolean> map = Lang.mapOf(HttpMethod.POST, false).and(HttpMethod.PUT, false).and(HttpMethod.PATCH, false).build();
        return new SimplifiedRouter(kosContext, router, map);
    }

    public static SimplifiedRouter wrapWithNoAutoBodyReader(KosContext kosContext, Router router) {
        return new SimplifiedRouter(kosContext, router, Collections.emptyMap());
    }

    public void handle(HttpServerRequest httpServerRequest) {
        this.interceptorHandler.handle(httpServerRequest);
    }

    private class SafeRequestInterceptor
    implements RequestInterceptor {
        final RequestInterceptor interceptor;
        final KosContext kosContext;

        @Override
        public void handle(HttpServerRequest httpServerRequest, Handler<HttpServerRequest> handler) {
            try {
                this.interceptor.handle(httpServerRequest, handler);
            }
            catch (Throwable throwable) {
                SimplifiedRouter.this.log.error((Object)"Could not execute handler", throwable);
                Response.sendError(this.kosContext, httpServerRequest, throwable);
            }
        }

        @Generated
        public SafeRequestInterceptor(RequestInterceptor requestInterceptor, KosContext kosContext) {
            this.interceptor = requestInterceptor;
            this.kosContext = kosContext;
        }
    }

    private class SafeRoutingContextHandler
    implements Handler<RoutingContext> {
        final Handler<RoutingContext> handler;
        final KosContext kosContext;

        public void handle(RoutingContext routingContext) {
            try {
                this.handler.handle((Object)routingContext);
            }
            catch (Throwable throwable) {
                SimplifiedRouter.this.log.error((Object)"Could not execute handler", throwable);
                Response.sendError(this.kosContext, routingContext, throwable);
            }
        }

        @Generated
        public SafeRoutingContextHandler(Handler<RoutingContext> handler, KosContext kosContext) {
            this.handler = handler;
            this.kosContext = kosContext;
        }
    }
}

