/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import kos.api.Application;
import kos.api.ConfigurationPlugin;
import kos.api.ImplementationLoader;
import kos.api.KosContext;
import kos.api.MutableKosContext;
import kos.core.KosException;
import kos.core.VertxWebServer;
import lombok.Generated;

public class Launcher {
    private final MutableKosContext conf;
    private Logger log;

    public Launcher() {
        this(new MutableKosContext());
    }

    public static void main(String[] stringArray) {
        new Launcher().run();
    }

    public void run() {
        this.configureKos();
        this.loadLogger();
        this.readDeploymentConfig((Handler<DeploymentContext>)((Handler)deploymentContext -> {
            this.deployCustomApplication((DeploymentContext)deploymentContext);
            this.deployWebServer((DeploymentContext)deploymentContext);
            this.deployVerticles((DeploymentContext)deploymentContext);
        }));
    }

    private void configureKos() {
        Iterable<ConfigurationPlugin> iterable = this.conf.getSpi().instancesExposedAs(ConfigurationPlugin.class);
        for (ConfigurationPlugin configurationPlugin : iterable) {
            configurationPlugin.configure(this.conf);
        }
        this.conf.getImplementationLoader().register(KosContext.class, this.conf);
    }

    void loadLogger() {
        this.log = this.conf.createLoggerFor(this.getClass());
    }

    void readDeploymentConfig(Handler<DeploymentContext> handler) {
        this.log.info((Object)"Reading deployment configuration...");
        this.conf.getConfigRetriever().getConfig(asyncResult -> {
            if (!asyncResult.succeeded()) {
                throw new KosException("Failed to read configuration", new Object[]{asyncResult.cause()});
            }
            DeploymentContext deploymentContext = new DeploymentContext(this.conf, (JsonObject)asyncResult.result());
            handler.handle((Object)deploymentContext);
        });
    }

    void deployCustomApplication(DeploymentContext deploymentContext) {
        ImplementationLoader.Result<Application> result = deploymentContext.instanceOf(Application.class);
        if (result.isPresent()) {
            Application application = result.get();
            this.log.info((Object)("Configuring custom application " + application.getClass().getCanonicalName() + "..."));
            application.configure(deploymentContext);
        }
    }

    void deployWebServer(DeploymentContext deploymentContext) {
        if (deploymentContext.getApplicationConfig().getBoolean("auto-config", Boolean.valueOf(true)).booleanValue()) {
            this.log.info((Object)"Deploying Vert.x WebServer...");
            VertxWebServer vertxWebServer = new VertxWebServer(deploymentContext.kosContext);
            deploymentContext.deploy((Verticle)vertxWebServer);
        }
    }

    void deployVerticles(DeploymentContext deploymentContext) {
        this.log.info((Object)"Looking for verticles...");
        Iterable<Verticle> iterable = deploymentContext.instancesExposedAs(Verticle.class);
        deploymentContext.deploy(iterable);
    }

    @Generated
    public Launcher(MutableKosContext mutableKosContext) {
        this.conf = mutableKosContext;
    }

    static class DeploymentContext
    implements kos.api.DeploymentContext {
        final KosContext kosContext;
        final JsonObject applicationConfig;
        final Logger log;

        DeploymentContext(KosContext kosContext, JsonObject jsonObject) {
            this.kosContext = kosContext;
            this.applicationConfig = jsonObject;
            this.log = kosContext.createLoggerFor(this.getClass());
        }

        <T> Iterable<T> instancesExposedAs(Class<T> clazz) {
            return this.kosContext.getImplementationLoader().instancesExposedAs(clazz);
        }

        <T> ImplementationLoader.Result<T> instanceOf(Class<T> clazz) {
            return this.kosContext.getImplementationLoader().instanceOf(clazz);
        }

        @Override
        public void deploy(Iterable<Verticle> iterable) {
            for (Verticle verticle : iterable) {
                this.deploy(verticle);
            }
        }

        @Override
        public void deploy(Verticle verticle) {
            DeploymentOptions deploymentOptions = new DeploymentOptions().setConfig(this.applicationConfig);
            this.log.debug((Object)("Deploying " + verticle.getClass().getCanonicalName() + "..."));
            this.kosContext.getDefaultVertx().deployVerticle(verticle, deploymentOptions);
        }

        @Generated
        public KosContext getKosContext() {
            return this.kosContext;
        }

        @Generated
        public JsonObject getApplicationConfig() {
            return this.applicationConfig;
        }

        @Generated
        public Logger getLog() {
            return this.log;
        }
    }
}

