/*
 * Decompiled with CFR 0.152.
 */
package kos.api;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import java.util.function.Function;
import kos.api.KosContext;
import kos.core.KosException;
import lombok.Generated;
import lombok.NonNull;

public interface Serializer {
    public static final Function<String, Serializer> INVALID_SERIALIZER = string -> {
        throw new KosException("No serializer available for '" + string + "'", new Object[0]);
    };

    public Buffer serialize(Object var1);

    public <T> T deserialize(Buffer var1, Class<T> var2);

    public String contentType();

    public static class PlainTextSerializer
    implements Serializer {
        final KosContext kosContext;

        @Override
        public Buffer serialize(@NonNull Object object) {
            if (object == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            return Buffer.buffer((String)object.toString());
        }

        @Override
        public <T> T deserialize(Buffer buffer, Class<T> clazz) {
            String string = buffer.toString();
            return this.kosContext.getStringConverter().convertTo(clazz, string);
        }

        @Override
        public String contentType() {
            return "text/plain";
        }

        @Generated
        public PlainTextSerializer(KosContext kosContext) {
            this.kosContext = kosContext;
        }
    }

    public static class JsonSerializer
    implements Serializer {
        @Override
        public String contentType() {
            return "application/json";
        }

        @Override
        public Buffer serialize(Object object) {
            return Json.encodeToBuffer((Object)object);
        }

        @Override
        public <T> T deserialize(Buffer buffer, Class<T> clazz) {
            return (T)Json.decodeValue((Buffer)buffer, clazz);
        }
    }
}

