/*
 * Decompiled with CFR 0.152.
 */
package kos.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Supplier;
import kos.core.KosException;
import kos.core.Lang;
import lombok.Generated;

public interface ImplementationLoader {
    public <T> Iterable<T> instancesExposedAs(Class<T> var1);

    public <T> Result<T> instanceOf(Class<T> var1);

    default public <T> T instanceOfOrFail(Class<T> clazz) {
        return (T)this.instanceOf(clazz).orElseGet(runtimeException -> {
            String string = "Could not load implementation for " + clazz.getCanonicalName();
            if (runtimeException == null) {
                string = string + "\n This usually happens when:";
                string = string + "\n  - there is no SPI defined for your class";
                string = string + "\n  - you are relying on a different ImplementationLoader but you haven't made your class manageable by it. Ex: missing annotations.";
                throw new KosException(string, new Object[0]);
            }
            throw new KosException((Throwable)runtimeException, string, new Object[0]);
        });
    }

    default public <T> Result<T> anyInstanceOf(Class<T> clazz) {
        return Result.of(this.instanceOf(clazz).orElseGet(() -> {
            Iterator iterator = this.instancesExposedAs(clazz).iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }));
    }

    public <T> void register(Class<T> var1, T var2);

    public static class Result<T> {
        final RuntimeException cause;
        final T data;

        public boolean isEmpty() {
            return this.data == null;
        }

        public boolean isPresent() {
            return !this.isEmpty();
        }

        public boolean failed() {
            return this.cause != null;
        }

        public T get() {
            return this.data;
        }

        public <E extends RuntimeException> T orElseThrow(Supplier<E> supplier) {
            if (this.isEmpty()) {
                throw (RuntimeException)supplier.get();
            }
            return this.data;
        }

        public T orElse(T t) {
            if (this.isEmpty()) {
                return t;
            }
            return this.data;
        }

        public T orElseGet(Supplier<T> supplier) {
            if (this.isEmpty()) {
                return supplier.get();
            }
            return this.data;
        }

        public T orElseGet(Function<RuntimeException, T> function) {
            if (this.isEmpty()) {
                return function.apply(this.cause);
            }
            return this.data;
        }

        public <R> Result<R> map(Function<T, R> function) {
            if (this.isEmpty()) {
                return Result.empty();
            }
            return Result.of(function.apply(this.data));
        }

        public String toString() {
            if (this.cause == null && this.data == null) {
                return "Result{empty=true}";
            }
            return "Result{cause=" + this.cause + ", data=" + this.data + "}";
        }

        public static <T, E extends RuntimeException> Result<T> failure(E e) {
            return new Result<Object>(e, null);
        }

        public static <T> Result<T> of(T t) {
            return new Result<T>(null, t);
        }

        public static <T> Result<T> empty() {
            return new Result<Object>(null, null);
        }

        @Generated
        public Result(RuntimeException runtimeException, T t) {
            this.cause = runtimeException;
            this.data = t;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Result)) {
                return false;
            }
            Result result = (Result)object;
            if (!result.canEqual(this)) {
                return false;
            }
            RuntimeException runtimeException = this.cause;
            RuntimeException runtimeException2 = result.cause;
            if (runtimeException == null ? runtimeException2 != null : !runtimeException.equals(runtimeException2)) {
                return false;
            }
            T t = this.data;
            T t2 = result.data;
            return !(t == null ? t2 != null : !t.equals(t2));
        }

        @Generated
        protected boolean canEqual(Object object) {
            return object instanceof Result;
        }

        @Generated
        public int hashCode() {
            int n = 1;
            RuntimeException runtimeException = this.cause;
            n = n * 59 + (runtimeException == null ? 43 : runtimeException.hashCode());
            T t = this.data;
            n = n * 59 + (t == null ? 43 : t.hashCode());
            return n;
        }
    }

    public static class SPIImplementationLoader
    implements ImplementationLoader {
        final Map<Class, Object> instances = new HashMap<Class, Object>();

        @Override
        public <T> Iterable<T> instancesExposedAs(Class<T> clazz) {
            return ServiceLoader.load(clazz);
        }

        @Override
        public <T> Result<T> instanceOf(Class<T> clazz) {
            Object object = this.instances.get(clazz);
            if (object != null) {
                return Result.of(object);
            }
            if (clazz.isInterface()) {
                return Lang.first(this.instancesExposedAs(clazz));
            }
            T t = Lang.instantiate(clazz);
            return Result.of(t);
        }

        @Override
        public <T> void register(Class<T> clazz, T t) {
            this.instances.put(clazz, t);
        }
    }
}

