/*
 * Decompiled with CFR 0.152.
 */
package kos.api;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.logging.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import kos.api.ExceptionHandler;
import kos.api.HandledResponseException;
import kos.api.KosContext;
import kos.api.Response;
import kos.core.Lang;

class DefaultExceptionHandler
implements ExceptionHandler {
    private final Lang.Lazy<Logger> log = Lang.Lazy.by(() -> kosContext.createLoggerFor(DefaultExceptionHandler.class));

    public DefaultExceptionHandler(KosContext kosContext) {
    }

    @Override
    public Response handle(HttpServerRequest httpServerRequest, HttpServerResponse httpServerResponse, Throwable throwable) {
        if (throwable instanceof HandledResponseException) {
            return ((HandledResponseException)throwable).response;
        }
        return this.handleUnknownError(httpServerRequest, throwable);
    }

    private Response handleUnknownError(HttpServerRequest httpServerRequest, Throwable throwable) {
        String string = String.format("Failed to handle request: %s - %s", httpServerRequest.method(), httpServerRequest.uri());
        this.log.get().error((Object)string, throwable);
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        Buffer buffer = Buffer.buffer((String)stringWriter.toString());
        Map<CharSequence, String> map = Collections.singletonMap(HttpHeaders.CONTENT_TYPE, "text/plain");
        return Response.wrap(buffer).statusCode(500).headers(map);
    }
}

