/*
 * Decompiled with CFR 0.152.
 */
package kos.core.client;

import io.vertx.core.MultiMap;
import io.vertx.ext.web.client.WebClient;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import kos.core.Kos;
import kos.core.KosException;
import kos.core.StringConverter;
import kos.core.client.Serializer;
import lombok.Generated;
import lombok.NonNull;

public final class RestClientConfiguration {
    public static final RestClientConfiguration EMPTY = RestClientConfiguration.withUrl("http://empty.url").build();
    @NonNull
    private final URL url;
    @NonNull
    private final MultiMap headers;
    @NonNull
    private final Serializer serializer;
    @NonNull
    private final WebClient client;
    @NonNull
    private final StringConverter stringConverter;
    private final AtomicReference<Object> isHttps = new AtomicReference();
    private final AtomicReference<Object> port = new AtomicReference();
    private final AtomicReference<Object> host = new AtomicReference();
    private final AtomicReference<Object> baseUrl = new AtomicReference();

    private int loadPort() {
        int n = this.url.getPort();
        if (n > 0) {
            return n;
        }
        if (this.isHttps()) {
            return 443;
        }
        return 80;
    }

    private String loadBaseUrl() {
        String string = this.getUrl().getPath();
        if ("".equals(string)) {
            return "/";
        }
        if (string.startsWith("/")) {
            return string;
        }
        return "/" + string;
    }

    public static MutableRestClientConfiguration withUrl(String string) {
        try {
            return RestClientConfiguration.defaults().url(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            throw new KosException(malformedURLException);
        }
    }

    @Generated
    private static MultiMap $default$headers() {
        return MultiMap.caseInsensitiveMultiMap();
    }

    @Generated
    private static Serializer $default$serializer() {
        return Kos.defaultRestClientSerializer;
    }

    @Generated
    private static WebClient $default$client() {
        return Kos.webClient.get();
    }

    @Generated
    private static StringConverter $default$stringConverter() {
        return Kos.stringConverter.get();
    }

    @Generated
    RestClientConfiguration(@NonNull URL uRL, @NonNull MultiMap multiMap, @NonNull Serializer serializer, @NonNull WebClient webClient, @NonNull StringConverter stringConverter) {
        if (uRL == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (multiMap == null) {
            throw new NullPointerException("headers is marked non-null but is null");
        }
        if (serializer == null) {
            throw new NullPointerException("serializer is marked non-null but is null");
        }
        if (webClient == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (stringConverter == null) {
            throw new NullPointerException("stringConverter is marked non-null but is null");
        }
        this.url = uRL;
        this.headers = multiMap;
        this.serializer = serializer;
        this.client = webClient;
        this.stringConverter = stringConverter;
    }

    @Generated
    public static MutableRestClientConfiguration defaults() {
        return new MutableRestClientConfiguration();
    }

    @NonNull
    @Generated
    public URL getUrl() {
        return this.url;
    }

    @NonNull
    @Generated
    public MultiMap getHeaders() {
        return this.headers;
    }

    @NonNull
    @Generated
    public Serializer getSerializer() {
        return this.serializer;
    }

    @NonNull
    @Generated
    public WebClient getClient() {
        return this.client;
    }

    @NonNull
    @Generated
    public StringConverter getStringConverter() {
        return this.stringConverter;
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RestClientConfiguration)) {
            return false;
        }
        RestClientConfiguration restClientConfiguration = (RestClientConfiguration)object;
        URL uRL = this.getUrl();
        URL uRL2 = restClientConfiguration.getUrl();
        if (uRL == null ? uRL2 != null : !((Object)uRL).equals(uRL2)) {
            return false;
        }
        MultiMap multiMap = this.getHeaders();
        MultiMap multiMap2 = restClientConfiguration.getHeaders();
        if (multiMap == null ? multiMap2 != null : !multiMap.equals(multiMap2)) {
            return false;
        }
        Serializer serializer = this.getSerializer();
        Serializer serializer2 = restClientConfiguration.getSerializer();
        if (serializer == null ? serializer2 != null : !serializer.equals(serializer2)) {
            return false;
        }
        WebClient webClient = this.getClient();
        WebClient webClient2 = restClientConfiguration.getClient();
        if (webClient == null ? webClient2 != null : !webClient.equals(webClient2)) {
            return false;
        }
        StringConverter stringConverter = this.getStringConverter();
        StringConverter stringConverter2 = restClientConfiguration.getStringConverter();
        if (stringConverter == null ? stringConverter2 != null : !stringConverter.equals(stringConverter2)) {
            return false;
        }
        if (this.isHttps() != restClientConfiguration.isHttps()) {
            return false;
        }
        if (this.getPort() != restClientConfiguration.getPort()) {
            return false;
        }
        String string = this.getHost();
        String string2 = restClientConfiguration.getHost();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.getBaseUrl();
        String string4 = restClientConfiguration.getBaseUrl();
        return !(string3 == null ? string4 != null : !string3.equals(string4));
    }

    @Generated
    public int hashCode() {
        int n = 1;
        URL uRL = this.getUrl();
        n = n * 59 + (uRL == null ? 43 : ((Object)uRL).hashCode());
        MultiMap multiMap = this.getHeaders();
        n = n * 59 + (multiMap == null ? 43 : multiMap.hashCode());
        Serializer serializer = this.getSerializer();
        n = n * 59 + (serializer == null ? 43 : serializer.hashCode());
        WebClient webClient = this.getClient();
        n = n * 59 + (webClient == null ? 43 : webClient.hashCode());
        StringConverter stringConverter = this.getStringConverter();
        n = n * 59 + (stringConverter == null ? 43 : stringConverter.hashCode());
        n = n * 59 + (this.isHttps() ? 79 : 97);
        n = n * 59 + this.getPort();
        String string = this.getHost();
        n = n * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.getBaseUrl();
        n = n * 59 + (string2 == null ? 43 : string2.hashCode());
        return n;
    }

    @Generated
    public String toString() {
        return "RestClientConfiguration(url=" + this.getUrl() + ", headers=" + this.getHeaders() + ", serializer=" + this.getSerializer() + ", client=" + this.getClient() + ", stringConverter=" + this.getStringConverter() + ", isHttps=" + this.isHttps() + ", port=" + this.getPort() + ", host=" + this.getHost() + ", baseUrl=" + this.getBaseUrl() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public boolean isHttps() {
        Object object = this.isHttps.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.isHttps;
            synchronized (atomicReference) {
                object = this.isHttps.get();
                if (object == null) {
                    boolean bl = this.getUrl().getProtocol().equals("https");
                    object = bl;
                    this.isHttps.set(object);
                }
            }
        }
        return (Boolean)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public int getPort() {
        Object object = this.port.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.port;
            synchronized (atomicReference) {
                object = this.port.get();
                if (object == null) {
                    int n = this.loadPort();
                    object = n;
                    this.port.set(object);
                }
            }
        }
        return (Integer)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getHost() {
        Object object = this.host.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.host;
            synchronized (atomicReference) {
                object = this.host.get();
                if (object == null) {
                    String string = this.getUrl().getHost();
                    object = string == null ? this.host : string;
                    this.host.set(object);
                }
            }
        }
        return (String)(object == this.host ? null : object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getBaseUrl() {
        Object object = this.baseUrl.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = this.baseUrl;
            synchronized (atomicReference) {
                object = this.baseUrl.get();
                if (object == null) {
                    String string = this.loadBaseUrl();
                    object = string == null ? this.baseUrl : string;
                    this.baseUrl.set(object);
                }
            }
        }
        return (String)(object == this.baseUrl ? null : object);
    }

    @Generated
    public static class MutableRestClientConfiguration {
        @Generated
        private URL url;
        @Generated
        private boolean headers$set;
        @Generated
        private MultiMap headers;
        @Generated
        private boolean serializer$set;
        @Generated
        private Serializer serializer;
        @Generated
        private boolean client$set;
        @Generated
        private WebClient client;
        @Generated
        private boolean stringConverter$set;
        @Generated
        private StringConverter stringConverter;

        @Generated
        MutableRestClientConfiguration() {
        }

        @Generated
        public MutableRestClientConfiguration url(@NonNull URL uRL) {
            if (uRL == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = uRL;
            return this;
        }

        @Generated
        public MutableRestClientConfiguration headers(@NonNull MultiMap multiMap) {
            if (multiMap == null) {
                throw new NullPointerException("headers is marked non-null but is null");
            }
            this.headers = multiMap;
            this.headers$set = true;
            return this;
        }

        @Generated
        public MutableRestClientConfiguration serializer(@NonNull Serializer serializer) {
            if (serializer == null) {
                throw new NullPointerException("serializer is marked non-null but is null");
            }
            this.serializer = serializer;
            this.serializer$set = true;
            return this;
        }

        @Generated
        public MutableRestClientConfiguration client(@NonNull WebClient webClient) {
            if (webClient == null) {
                throw new NullPointerException("client is marked non-null but is null");
            }
            this.client = webClient;
            this.client$set = true;
            return this;
        }

        @Generated
        public MutableRestClientConfiguration stringConverter(@NonNull StringConverter stringConverter) {
            if (stringConverter == null) {
                throw new NullPointerException("stringConverter is marked non-null but is null");
            }
            this.stringConverter = stringConverter;
            this.stringConverter$set = true;
            return this;
        }

        @Generated
        public RestClientConfiguration build() {
            MultiMap multiMap = this.headers;
            if (!this.headers$set) {
                multiMap = RestClientConfiguration.$default$headers();
            }
            Serializer serializer = this.serializer;
            if (!this.serializer$set) {
                serializer = RestClientConfiguration.$default$serializer();
            }
            WebClient webClient = this.client;
            if (!this.client$set) {
                webClient = RestClientConfiguration.$default$client();
            }
            StringConverter stringConverter = this.stringConverter;
            if (!this.stringConverter$set) {
                stringConverter = RestClientConfiguration.$default$stringConverter();
            }
            return new RestClientConfiguration(this.url, multiMap, serializer, webClient, stringConverter);
        }

        @Generated
        public String toString() {
            return "RestClientConfiguration.MutableRestClientConfiguration(url=" + this.url + ", headers=" + this.headers + ", serializer=" + this.serializer + ", client=" + this.client + ", stringConverter=" + this.stringConverter + ")";
        }
    }
}

