/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import injector.ExposedAs;
import injector.Singleton;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.Json;
import io.vertx.core.logging.Logger;
import io.vertx.ext.web.Router;
import kos.core.DefaultContextAttributesMemorizer;
import kos.core.Kos;
import kos.core.SimplifiedRouter;
import kos.core.WebServerEventListener;
import lombok.Generated;
import lombok.NonNull;

@Singleton
@ExposedAs(value=Verticle.class)
public class VertxWebServer
extends AbstractVerticle {
    private static final Logger log = Kos.logger(VertxWebServer.class);
    @NonNull
    private SimplifiedRouter router;

    public void start() {
        this.start((Promise<Void>)Promise.promise());
    }

    public void start(Promise<Void> promise) {
        try {
            this.beforeStart();
            this.startServer(promise);
            promise.complete();
        }
        catch (Throwable throwable) {
            log.error((Object)"Could not start server", throwable);
            promise.fail(throwable);
        }
    }

    private void startServer(Promise<Void> promise) {
        HttpServerOptions httpServerOptions = this.loadServerOptions();
        this.notifyWebServerDeploymentListeners(httpServerOptions);
        this.vertx.createHttpServer(httpServerOptions).requestHandler((Handler)this.router()).listen(asyncResult -> {
            if (asyncResult.failed()) {
                promise.fail(asyncResult.cause());
            } else {
                HttpServer httpServer = (HttpServer)asyncResult.result();
                Runtime.getRuntime().addShutdownHook(new Thread(() -> ((HttpServer)httpServer).close()));
                this.afterStart(httpServer);
            }
        });
    }

    protected HttpServerOptions loadServerOptions() {
        return Kos.implementationLoader.instanceOf(HttpServerOptions.class).orElseGet(this::createServerOptions);
    }

    private HttpServerOptions createServerOptions() {
        HttpServerOptions httpServerOptions = new HttpServerOptions(this.config());
        log.debug((Object)("Loading default HttpServerOptions: " + Json.encodePrettily((Object)httpServerOptions)));
        return httpServerOptions;
    }

    private void notifyWebServerDeploymentListeners(HttpServerOptions httpServerOptions) {
        WebServerEventListener.BeforeDeployEvent beforeDeployEvent = new WebServerEventListener.BeforeDeployEvent(this.vertx, httpServerOptions, this.router(), this.config());
        Kos.implementationLoader.instancesExposedAs(WebServerEventListener.class).forEach(webServerEventListener -> webServerEventListener.on(beforeDeployEvent));
    }

    protected void beforeStart() {
        Json.mapper.findAndRegisterModules();
        Json.prettyMapper.findAndRegisterModules();
    }

    protected void afterStart(HttpServer httpServer) {
        log.info((Object)("Server started at " + httpServer.actualPort() + " port"));
    }

    public SimplifiedRouter router() {
        if (this.router == null) {
            Router router = Router.router((Vertx)this.vertx);
            router.route().handler((Handler)new DefaultContextAttributesMemorizer());
            this.router = SimplifiedRouter.wrapWithAutoBodyReader(router);
        }
        return this.router;
    }

    @Generated
    public VertxWebServer router(@NonNull SimplifiedRouter simplifiedRouter) {
        if (simplifiedRouter == null) {
            throw new NullPointerException("router is marked non-null but is null");
        }
        this.router = simplifiedRouter;
        return this;
    }
}

