/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;

public interface StringConverter {
    public <T> StringConverter register(Class<T> var1, Function<String, T> var2);

    public <T> T convertTo(Class<T> var1, String var2);

    default public String asString(char c) {
        return String.valueOf(c);
    }

    default public String asString(boolean bl) {
        return String.valueOf(bl);
    }

    default public String asString(long l) {
        return String.valueOf(l);
    }

    default public String asString(double d) {
        return String.valueOf(d);
    }

    default public String asString(int n) {
        return String.valueOf(n);
    }

    default public String asString(Object object) {
        return String.valueOf(object);
    }

    public static class DefaultStringConverter
    implements StringConverter {
        private final Map<Class, Function> converters = new HashMap<Class, Function>();

        DefaultStringConverter() {
            this.register(String.class, Function.identity());
            this.register(Character.TYPE, string -> Character.valueOf(string.charAt(0)));
            this.register(Character.class, string -> Character.valueOf(string.charAt(0)));
            this.register(Boolean.TYPE, Boolean::valueOf);
            this.register(Boolean.class, Boolean::valueOf);
            this.register(Long.TYPE, Long::valueOf);
            this.register(Long.class, Long::valueOf);
            this.register(Double.TYPE, Double::valueOf);
            this.register(Double.class, Double::valueOf);
            this.register(Integer.TYPE, Integer::valueOf);
            this.register(Integer.class, Integer::valueOf);
            this.register(LocalDate.class, LocalDate::parse);
            this.register(LocalDateTime.class, LocalDateTime::parse);
            this.register(ZonedDateTime.class, ZonedDateTime::parse);
            this.register(UUID.class, UUID::fromString);
        }

        @Override
        public <T> StringConverter register(Class<T> clazz, Function<String, T> function) {
            this.converters.put(clazz, function);
            return this;
        }

        @Override
        public <T> T convertTo(Class<T> clazz, String string) {
            Function function = this.converters.computeIfAbsent(clazz, clazz2 -> {
                throw new UnsupportedOperationException("Can't convert String to " + clazz);
            });
            return (T)function.apply(string);
        }
    }
}

