/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import kos.core.Kos;
import lombok.NonNull;

public interface Serializer {
    public Buffer serialize(Object var1);

    public <T> T deserialize(Buffer var1, Class<T> var2);

    public String contentType();

    public static class PlainTextSerializer
    implements Serializer {
        @Override
        public Buffer serialize(@NonNull Object object) {
            if (object == null) {
                throw new NullPointerException("target is marked non-null but is null");
            }
            return Buffer.buffer((String)object.toString());
        }

        @Override
        public <T> T deserialize(Buffer buffer, Class<T> clazz) {
            String string = buffer.toString();
            return Kos.stringConverter.get().convertTo(clazz, string);
        }

        @Override
        public String contentType() {
            return "text/plain";
        }
    }

    public static class JsonSerializer
    implements Serializer {
        @Override
        public String contentType() {
            return "application/json";
        }

        @Override
        public Buffer serialize(Object object) {
            return Json.encodeToBuffer((Object)object);
        }

        @Override
        public <T> T deserialize(Buffer buffer, Class<T> clazz) {
            return (T)Json.decodeValue((Buffer)buffer, clazz);
        }
    }
}

