/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kos.core.Kos;

public class Launcher {
    private final Logger log = Kos.logger(Launcher.class);
    private final Iterable<Verticle> verticles = Kos.implementationLoader.instancesExposedAs(Verticle.class);
    private final List<Verticle> customVerticles = new ArrayList<Verticle>();

    public static void main(String[] stringArray) {
        new Launcher().run();
    }

    public void run() {
        this.configureApp();
        this.log.info((Object)"Loading configuration...");
        Kos.readConfig((Handler<JsonObject>)((Handler)jsonObject -> this.deployVerticlesWithConfig((JsonObject)jsonObject)));
    }

    public void configureApp() {
    }

    public void deploy(Verticle ... verticleArray) {
        Collections.addAll(this.customVerticles, verticleArray);
    }

    private void deployVerticlesWithConfig(JsonObject jsonObject) {
        this.log.info((Object)"Looking for verticles to be deployed...");
        this.deployVerticlesWithConfig(jsonObject, this.verticles);
        if (!this.customVerticles.isEmpty()) {
            this.deployVerticlesWithConfig(jsonObject, this.customVerticles);
        }
        this.log.debug((Object)"Deployment finished");
    }

    private void deployVerticlesWithConfig(JsonObject jsonObject, Iterable<Verticle> iterable) {
        Vertx vertx = Kos.defaultVertx.get();
        for (Verticle verticle : iterable) {
            DeploymentOptions deploymentOptions = new DeploymentOptions().setConfig(jsonObject);
            this.log.info((Object)("Deploying " + verticle.getClass().getCanonicalName() + "..."));
            vertx.deployVerticle(verticle, deploymentOptions);
        }
    }
}

