/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.config.ConfigRetriever;
import io.vertx.config.ConfigRetrieverOptions;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.JULLogDelegateFactory;
import io.vertx.core.logging.Logger;
import io.vertx.core.spi.logging.LogDelegate;
import io.vertx.core.spi.logging.LogDelegateFactory;
import io.vertx.ext.web.client.WebClient;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import kos.core.ConfigStoreOptionsFactory;
import kos.core.ExceptionHandler;
import kos.core.ImplementationLoader;
import kos.core.KosException;
import kos.core.Lang;
import kos.core.LazyLogDelegate;
import kos.core.PayloadSerializationStrategy;
import kos.core.Serializer;
import kos.core.StringConverter;
import kos.core.client.Serializer;

public final class Kos {
    private static final ImplementationLoader spi = new ImplementationLoader.SPIImplementationLoader();
    public static final Map<String, Serializer> serializers = Kos.loadSerializers();
    public static final Serializer defaultSerializer = serializers.get("application/json");
    public static final Map<String, kos.core.client.Serializer> restClientSerializers = Kos.loadRestClientSerializers();
    public static kos.core.client.Serializer defaultRestClientSerializer = restClientSerializers.get("application/json");
    public static PayloadSerializationStrategy payloadSerializationStrategy = PayloadSerializationStrategy.useDefaultSerializer();
    public static final int defaultStatusForEmptyResponses = 204;
    private static final LogDelegateFactory logFactory = Kos.loadLogDelegateFactory();
    private static final ConcurrentMap<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    public static final ImplementationLoader implementationLoader = spi.anyInstanceOf(ImplementationLoader.class).orElse(spi);
    public static final Supplier<Vertx> defaultVertx = Lang.Lazy.by(Kos::loadDefaultVertX);
    public static final Lang.Lazy<StringConverter> stringConverter = Lang.Lazy.by(() -> implementationLoader.anyInstanceOf(StringConverter.class).orElseGet(StringConverter.DefaultStringConverter::new));
    public static final Lang.Lazy<ExceptionHandler> exceptionHandler = Lang.Lazy.by(() -> implementationLoader.anyInstanceOf(ExceptionHandler.class).orElseGet(ExceptionHandler.DefaultExceptionHandler::new));
    public static final Lang.Lazy<JsonObject> config = Lang.Lazy.by(() -> {
        throw new KosException("Configuration not read yet", new Object[0]);
    });
    private static final Lang.Lazy<ConfigRetriever> configRetriever = Lang.Lazy.by(Kos::loadConfigRetriever);
    public static final Lang.Lazy<WebClient> webClient = Lang.Lazy.by(() -> implementationLoader.anyInstanceOf(WebClient.class).orElseGet(() -> WebClient.create((Vertx)defaultVertx.get())));

    private static Map<String, Serializer> loadSerializers() {
        HashMap<String, Serializer> hashMap = new HashMap<String, Serializer>();
        Serializer.JsonSerializer jsonSerializer = new Serializer.JsonSerializer();
        hashMap.put(jsonSerializer.contentType(), jsonSerializer);
        Serializer.PlainTextSerializer plainTextSerializer = new Serializer.PlainTextSerializer();
        hashMap.put(plainTextSerializer.contentType(), plainTextSerializer);
        spi.instancesExposedAs(Serializer.class).forEach(serializer -> hashMap.put(serializer.contentType(), (Serializer)serializer));
        return hashMap;
    }

    private static Map<String, kos.core.client.Serializer> loadRestClientSerializers() {
        HashMap<String, kos.core.client.Serializer> hashMap = new HashMap<String, kos.core.client.Serializer>();
        Serializer.JsonSerializer jsonSerializer = new Serializer.JsonSerializer();
        hashMap.put(jsonSerializer.contentType(), jsonSerializer);
        spi.instancesExposedAs(kos.core.client.Serializer.class).forEach(serializer -> hashMap.put(serializer.contentType(), (kos.core.client.Serializer)serializer));
        return hashMap;
    }

    private static LogDelegateFactory loadLogDelegateFactory() {
        String string = System.getProperty("vertx.logger-delegate-factory-class-name");
        if (string != null) {
            return Kos.loadLogDelegateFactory(string);
        }
        LogDelegateFactory logDelegateFactory = spi.anyInstanceOf(LogDelegateFactory.class).orElseGet(JULLogDelegateFactory::new);
        System.setProperty("vertx.logger-delegate-factory-class-name", logDelegateFactory.getClass().getCanonicalName());
        return logDelegateFactory;
    }

    private static LogDelegateFactory loadLogDelegateFactory(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(string);
            return (LogDelegateFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error instantiating transformer class \"" + string + "\"", exception);
        }
    }

    public static Logger logger(Class clazz) {
        return loggers.computeIfAbsent(clazz.getCanonicalName(), string -> new Logger((LogDelegate)new LazyLogDelegate(() -> logFactory.createDelegate(string))));
    }

    private static Vertx loadDefaultVertX() {
        Lang.Result<VertxOptions> result = implementationLoader.anyInstanceOf(VertxOptions.class);
        return result.isPresent() ? Vertx.vertx((VertxOptions)result.get()) : Vertx.vertx();
    }

    private static ConfigRetriever loadConfigRetriever() {
        Iterable<ConfigStoreOptionsFactory> iterable = Lang.sorted(spi.instancesExposedAs(ConfigStoreOptionsFactory.class), Comparator.comparingInt(ConfigStoreOptionsFactory::priority));
        ConfigRetrieverOptions configRetrieverOptions = new ConfigRetrieverOptions();
        iterable.forEach(configStoreOptionsFactory -> configRetrieverOptions.addStore(configStoreOptionsFactory.create()));
        return spi.anyInstanceOf(ConfigRetriever.class).orElseGet(() -> ConfigRetriever.create((Vertx)defaultVertx.get(), (ConfigRetrieverOptions)configRetrieverOptions));
    }

    public static void readConfig(Handler<JsonObject> handler) {
        configRetriever.get().getConfig(asyncResult -> {
            if (!asyncResult.succeeded()) {
                throw new KosException("Failed to read configuration", new Object[]{asyncResult.cause()});
            }
            config.set((JsonObject)asyncResult.result());
            handler.handle((Object)((JsonObject)asyncResult.result()));
        });
    }
}

