/*
 * Decompiled with CFR 0.152.
 */
package kos.core.client;

import com.fasterxml.jackson.core.type.TypeReference;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;
import kos.core.client.Serializer;
import kos.core.client.SimpleTypeResponseHandler;
import kos.core.client.TypeReferenceResponseHandler;
import kos.core.client.UnexpectedRestClientResponse;
import lombok.Generated;

public abstract class ResponseHandler<T>
implements Handler<AsyncResult<HttpResponse<Buffer>>> {
    private static final String MSG_UNEXPECTED_RESPONSE = "Expected status between 200 and 299";
    private final Promise<T> promise = Promise.promise();
    protected final Serializer serializer;

    public void handle(AsyncResult<HttpResponse<Buffer>> asyncResult) {
        try {
            if (asyncResult.succeeded()) {
                this.tryHandle(asyncResult);
            } else {
                this.promise.fail(asyncResult.cause());
            }
        }
        catch (Throwable throwable) {
            this.promise.fail(throwable);
        }
    }

    private void tryHandle(AsyncResult<HttpResponse<Buffer>> asyncResult) {
        HttpResponse httpResponse = (HttpResponse)asyncResult.result();
        if (httpResponse.statusCode() > 299) {
            String string = "Expected status between 200 and 299, received " + httpResponse.statusCode();
            this.promise.fail((Throwable)new UnexpectedRestClientResponse(string, (HttpResponse<Buffer>)httpResponse));
        } else {
            T t = this.deserialize((HttpResponse<Buffer>)httpResponse);
            if (t == null) {
                this.promise.complete();
            } else {
                this.promise.complete(t);
            }
        }
    }

    protected abstract T deserialize(HttpResponse<Buffer> var1);

    public Future<T> future() {
        return this.promise.future();
    }

    public static <T> ResponseHandler<T> create(Serializer serializer, Class<T> clazz) {
        return new SimpleTypeResponseHandler<T>(serializer, clazz);
    }

    public static <T> ResponseHandler<T> create(Serializer serializer, TypeReference<T> typeReference) {
        return new TypeReferenceResponseHandler<T>(serializer, typeReference);
    }

    @Generated
    public ResponseHandler(Serializer serializer) {
        this.serializer = serializer;
    }
}

