/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.logging.Logger;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.Collections;
import java.util.Map;
import kos.core.Kos;
import kos.core.Lang;
import kos.core.RequestHandler;
import kos.core.RequestInterceptor;
import kos.core.RequestInterceptorHandler;
import kos.core.Response;
import lombok.Generated;

public class SimplifiedRouter
implements Handler<HttpServerRequest> {
    private static final Logger log = Kos.logger(SimplifiedRouter.class);
    private final Router router;
    private final RequestInterceptorHandler interceptorHandler;
    private final Map<HttpMethod, Boolean> httpMethodsThatMayReadBody;

    public SimplifiedRouter(Router router, Map<HttpMethod, Boolean> map) {
        this(router, new RequestInterceptorHandler((Handler<HttpServerRequest>)router), map);
    }

    private SimplifiedRouter(Router router, RequestInterceptorHandler requestInterceptorHandler, Map<HttpMethod, Boolean> map) {
        this.interceptorHandler = requestInterceptorHandler;
        this.router = router;
        this.httpMethodsThatMayReadBody = map;
    }

    public Router unwrap() {
        return this.router;
    }

    public void intercept(RequestInterceptor requestInterceptor) {
        log.info((Object)("Registering interceptor " + requestInterceptor.getClass().getCanonicalName()));
        this.interceptorHandler.register(requestInterceptor);
    }

    public void route(HttpMethod httpMethod, String string, RequestHandler requestHandler) {
        this.route(httpMethod, string, (Handler<RoutingContext>)requestHandler);
    }

    public void route(HttpMethod httpMethod, String string, Handler<RoutingContext> handler) {
        log.info((Object)("Registering router " + httpMethod + " " + string));
        boolean bl = this.httpMethodsThatMayReadBody.replace(httpMethod, false, true);
        if (bl) {
            this.router.route().method(httpMethod).handler((Handler)BodyHandler.create());
        }
        this.router.route(httpMethod, string).handler((Handler)SafeRoutingContextHandler.wrap(handler));
        log.debug((Object)("Registered " + handler.getClass()));
    }

    public static SimplifiedRouter wrapWithAutoBodyReader(Router router) {
        Map<HttpMethod, Boolean> map = Lang.mapOf(HttpMethod.POST, false).and(HttpMethod.PUT, false).and(HttpMethod.PATCH, false).build();
        return new SimplifiedRouter(router, map);
    }

    public static SimplifiedRouter wrapWithNoAuthBodyReader(Router router) {
        return new SimplifiedRouter(router, Collections.emptyMap());
    }

    public void handle(HttpServerRequest httpServerRequest) {
        this.interceptorHandler.handle(httpServerRequest);
    }

    private static class SafeRoutingContextHandler
    implements Handler<RoutingContext> {
        final Handler<RoutingContext> handler;

        public void handle(RoutingContext routingContext) {
            try {
                this.handler.handle((Object)routingContext);
            }
            catch (Throwable throwable) {
                Response.sendError(routingContext, throwable);
            }
        }

        @Generated
        private SafeRoutingContextHandler(Handler<RoutingContext> handler) {
            this.handler = handler;
        }

        @Generated
        public static SafeRoutingContextHandler wrap(Handler<RoutingContext> handler) {
            return new SafeRoutingContextHandler(handler);
        }
    }
}

