/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import kos.core.EmptyResponse;
import kos.core.Kos;
import kos.core.RawResponse;
import kos.core.SerializableResponse;
import kos.core.Serializer;

public interface Response {
    public static final Response CREATED = Response.empty(201);
    public static final Response ACCEPTED = Response.empty(202);
    public static final Response NO_CONTENT = Response.empty(204);
    public static final Response BAD_REQUEST = Response.empty(400);
    public static final Response UNAUTHORIZED = Response.empty(401);
    public static final Response FORBIDDEN = Response.empty(403);
    public static final Response NOT_FOUND = Response.empty(404);
    public static final Response METHOD_NOT_ALLOWED = Response.empty(405);
    public static final Response NOT_ACCEPTABLE = Response.empty(406);
    public static final Response CONFLICT = Response.empty(409);
    public static final Response GONE = Response.empty(410);
    public static final Response TOO_MANY_REQUESTS = Response.empty(429);
    public static final Response NOT_IMPLEMENTED = Response.empty(501);
    public static final Response BAD_GATEWAY = Response.empty(502);
    public static final Response SERVICE_UNAVAILABLE = Response.empty(503);
    public static final Response GATEWAY_TIMEOUT = Response.empty(504);

    public int statusCode();

    public Response statusCode(int var1);

    public Map<? extends CharSequence, ? extends CharSequence> headers();

    public Response headers(Map<? extends CharSequence, ? extends CharSequence> var1);

    public void send(HttpServerResponse var1);

    public static Response empty() {
        return new EmptyResponse();
    }

    public static Response empty(int n) {
        return new EmptyResponse().statusCode(n);
    }

    public static Response wrap(Buffer buffer) {
        return new RawResponse(buffer);
    }

    public static <T> Response of(T t) {
        return new SerializableResponse<T>(t);
    }

    public static <T> Response ofNullable(T t) {
        if (t == null) {
            return Response.empty();
        }
        return new SerializableResponse<T>(t);
    }

    public static void send(RoutingContext routingContext, Object object) {
        HttpServerResponse httpServerResponse = routingContext.response();
        Serializer serializer = Kos.payloadSerializationStrategy.serializerFor(httpServerResponse);
        Buffer buffer = serializer.serialize(object);
        httpServerResponse.setStatusCode(200);
        httpServerResponse.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)serializer.contentType());
        httpServerResponse.end(buffer);
    }

    public static void send(RoutingContext routingContext, Response response) {
        HttpServerResponse httpServerResponse = routingContext.response();
        httpServerResponse.setStatusCode(response.statusCode());
        for (Map.Entry<? extends CharSequence, ? extends CharSequence> entry : response.headers().entrySet()) {
            httpServerResponse.putHeader(entry.getKey(), entry.getValue());
        }
        response.send(httpServerResponse);
    }

    public static void sendError(RoutingContext routingContext, Throwable throwable) {
        Response response = Kos.exceptionHandler.get().handle(routingContext, throwable);
        Response.send(routingContext, response);
    }

    public static void sendDefaultNoContent(RoutingContext routingContext) {
        HttpServerResponse httpServerResponse = routingContext.response();
        httpServerResponse.setStatusCode(204);
        httpServerResponse.end();
    }
}

