/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.util.function.Function;
import kos.core.HeaderParserStrategy;
import kos.core.Kos;
import kos.core.KosException;
import kos.core.Serializer;
import kos.core.SingleSerializerStrategy;

public interface PayloadSerializationStrategy {
    public static final Function<String, Serializer> INVALID_SERIALIZER = string -> {
        throw new KosException("No serializer available for '" + string + "'", new Object[0]);
    };

    public Serializer serializerFor(HttpServerResponse var1);

    public Serializer serializerFor(HttpServerRequest var1);

    public static PayloadSerializationStrategy useDefaultSerializer() {
        return new SingleSerializerStrategy(Kos.defaultSerializer);
    }

    public static PayloadSerializationStrategy useSerializer(String string) {
        Serializer serializer = Kos.serializers.computeIfAbsent(string, INVALID_SERIALIZER);
        return new SingleSerializerStrategy(serializer);
    }

    public static PayloadSerializationStrategy basedOnHttpHeader(String string) {
        return new HeaderParserStrategy(HttpHeaders.CONTENT_TYPE, string);
    }
}

