/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.Future;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import java.util.function.Supplier;
import kos.core.KosException;
import lombok.Generated;

public final class Lang {
    private Lang() {
    }

    public static <T> T instantiate(String string) {
        return Lang.instantiate(Lang.classFor(string));
    }

    public static <T> Class<T> classFor(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new KosException(classNotFoundException);
        }
    }

    public static <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new KosException(reflectiveOperationException);
        }
    }

    public static <T> Result<T> first(Iterable<T> iterable) {
        return Lang.first(iterable, object -> true);
    }

    public static <T> boolean matches(Iterable<T> iterable, Function<T, Boolean> function) {
        for (T t : iterable) {
            if (!function.apply(t).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <T> Result<T> first(Iterable<T> iterable, Function<T, Boolean> function) {
        for (T t : iterable) {
            if (!function.apply(t).booleanValue()) continue;
            return Result.of(t);
        }
        return Result.empty();
    }

    public static <T> List<T> filter(Collection<T> collection, Function<T, Boolean> function) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : collection) {
            if (!function.apply(t).booleanValue()) continue;
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T, N> List<N> convert(Iterable<T> iterable, Function<T, N> function) {
        ArrayList<N> arrayList = new ArrayList<N>();
        for (T t : iterable) {
            arrayList.add(function.apply(t));
        }
        return arrayList;
    }

    public static <K, V> MapBuilder<K, V> mapOf(K k, V v) {
        return new MapBuilder<K, V>().and(k, v);
    }

    public static List<String> nonEmptySetOfString(Iterable<String> iterable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : iterable) {
            if (string == null || string.isEmpty()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static <T> Iterable<T> sorted(Iterable<T> iterable, Comparator<T> comparator) {
        ArrayList<T> arrayList = new ArrayList<T>();
        iterable.forEach(arrayList::add);
        arrayList.sort(comparator);
        return arrayList;
    }

    public static <T> Future<T> asFuture(Future<T> future) {
        return future;
    }

    public static <T> Future<T> asFuture(T t) {
        return Future.succeededFuture(t);
    }

    public static <T> T await(Future<T> future) {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[1];
        if (!stackTraceElement.getClassName().startsWith("kos.")) {
            throw new UnsupportedOperationException("Await was not designed for production usage");
        }
        while (!future.succeeded() && !future.failed()) {
            LockSupport.parkNanos(2L);
        }
        if (future.succeeded()) {
            return (T)future.result();
        }
        throw new KosException(future.cause().getMessage(), new Object[]{future.cause()});
    }

    public static class Result<T> {
        final RuntimeException cause;
        final T data;

        public boolean isEmpty() {
            return this.data == null;
        }

        public boolean isPresent() {
            return !this.isEmpty();
        }

        public boolean failed() {
            return this.cause != null;
        }

        public T get() {
            return this.data;
        }

        public <E extends RuntimeException> T orElseThrow(Supplier<E> supplier) {
            if (this.isEmpty()) {
                throw (RuntimeException)supplier.get();
            }
            return this.data;
        }

        public T orElse(T t) {
            if (this.isEmpty()) {
                return t;
            }
            return this.data;
        }

        public T orElseGet(Supplier<T> supplier) {
            if (this.isEmpty()) {
                return supplier.get();
            }
            return this.data;
        }

        public T orElseGet(Function<RuntimeException, T> function) {
            if (this.isEmpty()) {
                return function.apply(this.cause);
            }
            return this.data;
        }

        public <R> Result<R> map(Function<T, R> function) {
            if (this.isEmpty()) {
                return Result.empty();
            }
            return Result.of(function.apply(this.data));
        }

        public static <T, E extends RuntimeException> Result<T> failure(E e) {
            return new Result<Object>(e, null);
        }

        public static <T> Result<T> of(T t) {
            return new Result<T>(null, t);
        }

        public static <T> Result<T> empty() {
            return new Result<Object>(null, null);
        }

        @Generated
        public Result(RuntimeException runtimeException, T t) {
            this.cause = runtimeException;
            this.data = t;
        }

        @Generated
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Result)) {
                return false;
            }
            Result result = (Result)object;
            if (!result.canEqual(this)) {
                return false;
            }
            RuntimeException runtimeException = this.cause;
            RuntimeException runtimeException2 = result.cause;
            if (runtimeException == null ? runtimeException2 != null : !runtimeException.equals(runtimeException2)) {
                return false;
            }
            T t = this.data;
            T t2 = result.data;
            return !(t == null ? t2 != null : !t.equals(t2));
        }

        @Generated
        protected boolean canEqual(Object object) {
            return object instanceof Result;
        }

        @Generated
        public int hashCode() {
            int n = 1;
            RuntimeException runtimeException = this.cause;
            n = n * 59 + (runtimeException == null ? 43 : runtimeException.hashCode());
            T t = this.data;
            n = n * 59 + (t == null ? 43 : t.hashCode());
            return n;
        }
    }

    public static class Lazy<T>
    implements Supplier<T> {
        private final Supplier<T> supplier;
        private T data;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.data == null) {
                Lazy lazy = this;
                synchronized (lazy) {
                    if (this.data == null) {
                        this.data = this.supplier.get();
                    }
                }
            }
            return this.data;
        }

        public synchronized void set(T t) {
            this.data = t;
        }

        public static <T> Lazy<T> by(Supplier<T> supplier) {
            return new Lazy<T>(supplier);
        }

        @Generated
        public Lazy(Supplier<T> supplier) {
            this.supplier = supplier;
        }
    }

    public static class MapBuilder<K, V> {
        final Map<K, V> data = new HashMap();

        public MapBuilder<K, V> and(K k, V v) {
            this.data.put(k, v);
            return this;
        }

        public Map<K, V> build() {
            return this.data;
        }

        @Generated
        private MapBuilder() {
        }
    }
}

