/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import java.util.Iterator;
import java.util.ServiceLoader;
import kos.core.KosException;
import kos.core.Lang;

public interface ImplementationLoader {
    public <T> Iterable<T> instancesExposedAs(Class<T> var1);

    public <T> Lang.Result<T> instanceOf(Class<T> var1);

    default public <T> T instanceOfOrFail(Class<T> clazz) {
        return (T)this.instanceOf(clazz).orElseGet(runtimeException -> {
            String string = "Could not load implementation for " + clazz.getCanonicalName();
            if (runtimeException == null) {
                string = string + "\n This usually happens when:";
                string = string + "\n  - there is no SPI defined for your class";
                string = string + "\n  - you are relying on a different ImplementationLoader but you haven't made your class manageable by it. Ex: missing annotations.";
                throw new KosException(string, new Object[0]);
            }
            throw new KosException((Throwable)runtimeException, string, new Object[0]);
        });
    }

    default public <T> Lang.Result<T> anyInstanceOf(Class<T> clazz) {
        return Lang.Result.of(this.instanceOf(clazz).orElseGet(() -> {
            Iterator iterator = this.instancesExposedAs(clazz).iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }));
    }

    public static class SPIImplementationLoader
    implements ImplementationLoader {
        @Override
        public <T> Iterable<T> instancesExposedAs(Class<T> clazz) {
            return ServiceLoader.load(clazz);
        }

        @Override
        public <T> Lang.Result<T> instanceOf(Class<T> clazz) {
            if (clazz.isInterface()) {
                return Lang.first(this.instancesExposedAs(clazz));
            }
            T t = Lang.instantiate(clazz);
            return Lang.Result.of(t);
        }
    }
}

