/*
 * Decompiled with CFR 0.152.
 */
package kos.core;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.logging.Logger;
import io.vertx.ext.web.RoutingContext;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import kos.core.Kos;
import kos.core.Response;

public interface ExceptionHandler {
    public Response handle(RoutingContext var1, Throwable var2);

    public static class DefaultExceptionHandler
    implements ExceptionHandler {
        private final Logger log = Kos.logger(DefaultExceptionHandler.class);

        @Override
        public Response handle(RoutingContext routingContext, Throwable throwable) {
            String string = String.format("Failed to handle request: %s - %s", routingContext.request().method(), routingContext.request().uri());
            this.log.error((Object)string, throwable);
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            Buffer buffer = Buffer.buffer((String)stringWriter.toString());
            Map<CharSequence, String> map = Collections.singletonMap(HttpHeaders.CONTENT_TYPE, "text/plain");
            return Response.wrap(buffer).statusCode(500).headers(map);
        }
    }
}

