/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.util;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Scanner;

public final class BulldogUtil {
    public static void sleepMs(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void sleepNs(long l) {
        long l2 = System.nanoTime();
        long l3 = l2 + l;
        long l4 = 0L;
        while ((l4 = System.nanoTime()) < l3) {
        }
    }

    public static String bytesToString(byte[] byArray, String string) {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes may not be null in string conversion");
        }
        if (byArray.length == 0) {
            return null;
        }
        try {
            return new String(byArray, string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown encoding");
        }
    }

    public static String bytesToString(byte[] byArray) {
        return BulldogUtil.bytesToString(byArray, "ASCII");
    }

    public static String convertStreamToString(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }

    public static String readFileAsString(String string) {
        try {
            byte[] byArray = Files.readAllBytes(Paths.get(string, new String[0]));
            return new String(byArray, Charset.defaultCharset());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isStringNumeric(String string) {
        return string.matches("-?\\d+(\\.\\d+)?");
    }

    public static final int getUnsignedByte(byte by) {
        return by & 0xFF;
    }
}

