/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.platform;

import io.silverspoon.bulldog.core.pin.Pin;
import io.silverspoon.bulldog.core.platform.PinProvider;
import java.util.ArrayList;
import java.util.List;

public class AbstractPinProvider
implements PinProvider {
    private List<Pin> pins = new ArrayList<Pin>();

    @Override
    public List<Pin> getPins() {
        return this.pins;
    }

    @Override
    public Pin getPin(int n) {
        for (Pin pin : this.getPins()) {
            if (pin.getAddress() != n) continue;
            return pin;
        }
        return null;
    }

    @Override
    public Pin getPin(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException("Null may not be passed as a name for a port.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Index cannot be smaller than 0");
        }
        for (Pin pin : this.getPins()) {
            if (!string.equals(pin.getPort()) || n != pin.getIndexOnPort()) continue;
            return pin;
        }
        return null;
    }

    @Override
    public Pin getPin(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null may not be passed as a name for a pin.");
        }
        for (Pin pin : this.getPins()) {
            if (!string.equals(pin.getName())) continue;
            return pin;
        }
        return null;
    }

    @Override
    public Pin getPinByAlias(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null may not be passed as an alias name for a pin.");
        }
        for (Pin pin : this.getPins()) {
            if (!string.equals(pin.getAlias())) continue;
            return pin;
        }
        return null;
    }
}

