/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.io.bus;

import io.silverspoon.bulldog.core.io.IOPort;
import io.silverspoon.bulldog.core.io.bus.Bus;
import io.silverspoon.bulldog.core.io.bus.BusConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BusDevice
implements IOPort {
    private BusConnection connection;
    private String name;
    private String alias;

    public BusDevice(BusConnection busConnection) {
        this.connection = busConnection;
    }

    public BusDevice(Bus bus, int n) {
        this(bus.createConnection(n));
    }

    @Override
    public void writeByte(int n) throws IOException {
        this.getBusConnection().writeByte(n);
    }

    @Override
    public void writeBytes(byte[] byArray) throws IOException {
        this.getBusConnection().writeBytes(byArray);
    }

    @Override
    public void writeString(String string) throws IOException {
        this.getBusConnection().writeString(string);
    }

    @Override
    public byte readByte() throws IOException {
        return this.getBusConnection().readByte();
    }

    @Override
    public int readBytes(byte[] byArray) throws IOException {
        return this.getBusConnection().readBytes(byArray);
    }

    @Override
    public String readString() throws IOException {
        return this.getBusConnection().readString();
    }

    public BusConnection getBusConnection() {
        return this.connection;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String string) {
        this.alias = string;
    }

    @Override
    public void open() throws IOException {
        this.getBusConnection().getBus().open();
    }

    @Override
    public boolean isOpen() {
        return this.getBusConnection().getBus().isOpen();
    }

    @Override
    public void close() throws IOException {
        this.getBusConnection().getBus().close();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getBusConnection().getOutputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getBusConnection().getInputStream();
    }
}

