/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.io;

import io.silverspoon.bulldog.core.Signal;
import io.silverspoon.bulldog.core.gpio.DigitalIO;
import io.silverspoon.bulldog.core.io.PinIOGroup;
import io.silverspoon.bulldog.core.util.BitMagic;
import java.io.IOException;
import java.io.InputStream;

public class PinIOInputStream
extends InputStream {
    private PinIOGroup group;

    public PinIOInputStream(PinIOGroup pinIOGroup) {
        this.group = pinIOGroup;
    }

    @Override
    public int read() throws IOException {
        this.group.startEnable();
        int n = 0;
        for (int i = 0; i < this.group.getDataPins().length; ++i) {
            DigitalIO digitalIO = this.group.getDataPins()[i];
            Signal signal = digitalIO.read();
            n = BitMagic.setBit(n, i, signal.getNumericValue());
        }
        this.group.endEnable();
        return n;
    }
}

