/*
 * Decompiled with CFR 0.152.
 */
package io.silverspoon.bulldog.core.gpio.util;

import io.silverspoon.bulldog.core.gpio.DigitalOutput;
import io.silverspoon.bulldog.core.util.BulldogUtil;
import io.silverspoon.bulldog.core.util.DaemonThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Blinker
implements Runnable {
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new DaemonThreadFactory());
    private ScheduledFuture<?> future;
    private DigitalOutput output;
    private int durationMilliseconds = 0;
    private long startTime = 0L;
    private int times = 0;
    private boolean doTimes = false;

    public Blinker(DigitalOutput digitalOutput) {
        this.output = digitalOutput;
    }

    public void startBlinking(int n) {
        this.startBlinking(n, 0);
    }

    public void blinkTimes(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("You must specify to blink at least one time");
        }
        this.times = n2 * 2;
        this.doTimes = true;
        this.startBlinking(n);
    }

    public void startBlinking(int n, int n2) {
        if (this.future != null) {
            this.future.cancel(true);
        }
        this.durationMilliseconds = n2;
        this.startTime = System.currentTimeMillis();
        this.output.blockPin();
        this.future = this.executorService.scheduleAtFixedRate(this, 0L, n / 2, TimeUnit.MILLISECONDS);
    }

    public void stopBlinking() {
        if (this.future == null) {
            return;
        }
        this.future.cancel(true);
        this.future = null;
        this.doTimes = false;
        this.output.unblockPin();
    }

    @Override
    public void run() {
        if (!this.doTimes) {
            long l;
            if (this.durationMilliseconds > 0 && (l = System.currentTimeMillis() - this.startTime) >= (long)this.durationMilliseconds) {
                this.stopBlinking();
            }
        } else {
            --this.times;
            if (this.times == 0) {
                this.stopBlinking();
                this.doTimes = false;
            }
        }
        this.output.toggle();
    }

    public boolean isBlinking() {
        if (this.future != null) {
            return !this.future.isDone();
        }
        return false;
    }

    public void awaitBlinkingStopped() {
        while (this.isBlinking()) {
            BulldogUtil.sleepMs(1L);
        }
    }
}

